/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data.experimental;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

public final class DataServiceDataset
extends RawOp
implements Operand<TType> {
    private Output<?> handle;

    public static DataServiceDataset create(Scope scope, Operand<TInt64> datasetId, Operand<TString> processingMode, Operand<TString> address, Operand<TString> protocol, Operand<TString> jobName, Operand<TInt64> maxOutstandingRequests, Operand<?> iterationCounter, List<DataType<?>> outputTypes, List<Shape> outputShapes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("DataServiceDataset", scope.makeOpName("DataServiceDataset"));
        opBuilder.addInput(datasetId.asOutput());
        opBuilder.addInput(processingMode.asOutput());
        opBuilder.addInput(address.asOutput());
        opBuilder.addInput(protocol.asOutput());
        opBuilder.addInput(jobName.asOutput());
        opBuilder.addInput(maxOutstandingRequests.asOutput());
        opBuilder.addInput(iterationCounter.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        DataType[] outputTypesArray = new DataType[outputTypes.size()];
        for (int i = 0; i < outputTypesArray.length; ++i) {
            outputTypesArray[i] = outputTypes.get(i);
        }
        opBuilder.setAttr("output_types", outputTypesArray);
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        if (options != null) {
            for (Options opts : options) {
                if (opts.taskRefreshIntervalHintMs == null) continue;
                opBuilder.setAttr("task_refresh_interval_hint_ms", opts.taskRefreshIntervalHintMs);
            }
        }
        return new DataServiceDataset(opBuilder.build());
    }

    public static Options taskRefreshIntervalHintMs(Long taskRefreshIntervalHintMs) {
        return new Options().taskRefreshIntervalHintMs(taskRefreshIntervalHintMs);
    }

    public Output<?> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    private DataServiceDataset(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static class Options {
        private Long taskRefreshIntervalHintMs;

        public Options taskRefreshIntervalHintMs(Long taskRefreshIntervalHintMs) {
            this.taskRefreshIntervalHintMs = taskRefreshIntervalHintMs;
            return this;
        }

        private Options() {
        }
    }
}

