/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.HashMap;
import java.util.Map;
import org.tensorflow.DataType;
import org.tensorflow.TensorFlow;
import org.tensorflow.types.TBfloat16;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TFloat16;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TFloat64;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.TString;
import org.tensorflow.types.TUint8;

final class DataTypes {
    private static final Map<Integer, DataType<?>> DATA_TYPE_REGISTRY = new HashMap();

    DataTypes() {
    }

    static DataType<?> fromNativeCode(int nativeCode) {
        DataType<?> dataType = DATA_TYPE_REGISTRY.get(nativeCode);
        if (dataType == null) {
            throw new IllegalArgumentException("DataType " + nativeCode + " is not recognized in Java (version " + TensorFlow.version() + ")");
        }
        return dataType;
    }

    private static void register(DataType<?> dataType) {
        DATA_TYPE_REGISTRY.put(dataType.nativeCode(), dataType);
        DATA_TYPE_REGISTRY.put(dataType.nativeCode() + 100, dataType);
    }

    static {
        DataTypes.register(TBool.DTYPE);
        DataTypes.register(TFloat64.DTYPE);
        DataTypes.register(TFloat32.DTYPE);
        DataTypes.register(TFloat16.DTYPE);
        DataTypes.register(TInt32.DTYPE);
        DataTypes.register(TInt64.DTYPE);
        DataTypes.register(TString.DTYPE);
        DataTypes.register(TUint8.DTYPE);
        DataTypes.register(TBfloat16.DTYPE);
    }
}

