/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.ndarray.impl.sequence;

import java.util.NoSuchElementException;
import org.tensorflow.tools.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.tools.ndarray.impl.sequence.PositionIterator;

class SequentialPositionIterator
implements PositionIterator {
    private final long stride;
    private final long end;
    private long index;

    @Override
    public boolean hasNext() {
        return this.index < this.end;
    }

    @Override
    public long nextLong() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.stride * this.index++;
    }

    SequentialPositionIterator(DimensionalSpace dimensions, int dimensionIdx) {
        long size = 1L;
        for (int i = 0; i <= dimensionIdx; ++i) {
            size *= dimensions.get(i).numElements();
        }
        this.stride = dimensions.get(dimensionIdx).elementSize();
        this.end = size;
    }

    SequentialPositionIterator(long stride, long end) {
        this.stride = stride;
        this.end = end;
    }
}

