/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.ndarray.impl.dense;

import org.tensorflow.tools.Shape;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.IntDataBuffer;
import org.tensorflow.tools.ndarray.IntNdArray;
import org.tensorflow.tools.ndarray.NdArray;
import org.tensorflow.tools.ndarray.impl.dense.AbstractDenseNdArray;
import org.tensorflow.tools.ndarray.impl.dense.DataTransfer;
import org.tensorflow.tools.ndarray.impl.dense.Validator;
import org.tensorflow.tools.ndarray.impl.dimension.DimensionalSpace;

public class IntDenseNdArray
extends AbstractDenseNdArray<Integer, IntNdArray>
implements IntNdArray {
    private final IntDataBuffer buffer;

    public static IntNdArray create(IntDataBuffer buffer, Shape shape) {
        Validator.denseShape(buffer, shape);
        return new IntDenseNdArray(buffer, shape);
    }

    @Override
    public int getInt(long ... indices) {
        return this.buffer.getInt(this.positionOf(indices, true));
    }

    @Override
    public IntNdArray setInt(int value, long ... indices) {
        this.buffer.setInt(value, this.positionOf(indices, true));
        return this;
    }

    @Override
    public IntNdArray copyTo(NdArray<Integer> dst) {
        Validator.copyToNdArrayArgs(this, dst);
        if (dst instanceof IntDenseNdArray) {
            IntDenseNdArray intDst = (IntDenseNdArray)dst;
            DataTransfer.execute(this.buffer, this.dimensions(), intDst.buffer, intDst.dimensions(), DataTransfer::ofInt);
        } else {
            this.slowCopyTo(dst);
        }
        return this;
    }

    @Override
    public IntNdArray read(IntDataBuffer dst) {
        Validator.readToBufferArgs(this, dst);
        DataTransfer.execute(this.buffer, this.dimensions(), dst, DataTransfer::ofInt);
        return this;
    }

    @Override
    public IntNdArray write(IntDataBuffer src) {
        Validator.writeFromBufferArgs(this, src);
        DataTransfer.execute(src, this.buffer, this.dimensions(), DataTransfer::ofInt);
        return this;
    }

    protected IntDenseNdArray(IntDataBuffer buffer, Shape shape) {
        this(buffer, DimensionalSpace.create(shape));
    }

    @Override
    IntDenseNdArray instantiate(DataBuffer<Integer> buffer, DimensionalSpace dimensions) {
        return new IntDenseNdArray((IntDataBuffer)buffer, dimensions);
    }

    protected IntDataBuffer buffer() {
        return this.buffer;
    }

    private IntDenseNdArray(IntDataBuffer buffer, DimensionalSpace dimensions) {
        super(dimensions);
        this.buffer = buffer;
    }
}

