/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl.raw;

import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.DataBufferWindow;
import org.tensorflow.tools.buffer.impl.AbstractDataBuffer;
import org.tensorflow.tools.buffer.impl.Validator;
import org.tensorflow.tools.buffer.impl.raw.RawDataBufferWindow;
import org.tensorflow.tools.buffer.impl.raw.UnsafeMemoryHandle;

abstract class AbstractRawDataBuffer<T, B extends DataBuffer<T>>
extends AbstractDataBuffer<T> {
    protected final UnsafeMemoryHandle memory;
    protected final boolean readOnly;

    @Override
    public long size() {
        return this.memory.size();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public B read(Object dst, int dstLength) {
        Validator.readArgs(this, dstLength, 0, dstLength);
        this.memory.copyTo(UnsafeMemoryHandle.fromArray(dst, dstLength), dstLength);
        return (B)this;
    }

    public B read(Object dst, int dstLength, int offset, int length) {
        Validator.readArgs(this, dstLength, offset, length);
        this.memory.copyTo(UnsafeMemoryHandle.fromArray(dst, dstLength).offset(offset), length);
        return (B)this;
    }

    public B write(Object src, int srcLength) {
        Validator.writeArgs(this, srcLength, 0, srcLength);
        UnsafeMemoryHandle.fromArray(src, srcLength).copyTo(this.memory, srcLength);
        return (B)this;
    }

    public B write(Object src, int srcLength, int offset, int length) {
        Validator.writeArgs(this, srcLength, offset, length);
        UnsafeMemoryHandle.fromArray(src, srcLength).offset(offset).copyTo(this.memory, length);
        return (B)this;
    }

    public B copyTo(DataBuffer<T> dst, long size) {
        Validator.copyToArgs(this, dst, size);
        if (dst instanceof AbstractRawDataBuffer) {
            AbstractRawDataBuffer unsafeDst = (AbstractRawDataBuffer)dst;
            this.memory.copyTo(unsafeDst.memory, size);
        } else {
            super.copyTo(dst, size);
        }
        return (B)this;
    }

    public B slice(long index, long size) {
        Validator.sliceArgs(this, index, size);
        return this.instantiate(this.memory.slice(index, size));
    }

    @Override
    public DataBufferWindow<B> window(long size) {
        B windowBuffer = this.instantiate(this.memory.slice(0L, size));
        return new RawDataBufferWindow((AbstractRawDataBuffer)windowBuffer, this.size());
    }

    protected abstract B instantiate(UnsafeMemoryHandle var1);

    AbstractRawDataBuffer(UnsafeMemoryHandle memory, boolean readOnly) {
        this.memory = memory;
        this.readOnly = readOnly;
    }
}

