/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.image;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

public final class QuantizedResizeBilinear<T extends TType>
extends RawOp {
    private Output<T> resizedImages;
    private Output<TFloat32> outMin;
    private Output<TFloat32> outMax;

    public static <T extends TType> QuantizedResizeBilinear<T> create(Scope scope, Operand<T> images, Operand<TInt32> size, Operand<TFloat32> min, Operand<TFloat32> max, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("QuantizedResizeBilinear", scope.makeOpName("QuantizedResizeBilinear"));
        opBuilder.addInput(images.asOutput());
        opBuilder.addInput(size.asOutput());
        opBuilder.addInput(min.asOutput());
        opBuilder.addInput(max.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        if (options != null) {
            for (Options opts : options) {
                if (opts.alignCorners != null) {
                    opBuilder.setAttr("align_corners", opts.alignCorners);
                }
                if (opts.halfPixelCenters == null) continue;
                opBuilder.setAttr("half_pixel_centers", opts.halfPixelCenters);
            }
        }
        return new QuantizedResizeBilinear<T>(opBuilder.build());
    }

    public static Options alignCorners(Boolean alignCorners) {
        return new Options().alignCorners(alignCorners);
    }

    public static Options halfPixelCenters(Boolean halfPixelCenters) {
        return new Options().halfPixelCenters(halfPixelCenters);
    }

    public Output<T> resizedImages() {
        return this.resizedImages;
    }

    public Output<TFloat32> outMin() {
        return this.outMin;
    }

    public Output<TFloat32> outMax() {
        return this.outMax;
    }

    private QuantizedResizeBilinear(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.resizedImages = operation.output(outputIdx++);
        this.outMin = operation.output(outputIdx++);
        this.outMax = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean alignCorners;
        private Boolean halfPixelCenters;

        public Options alignCorners(Boolean alignCorners) {
            this.alignCorners = alignCorners;
            return this;
        }

        public Options halfPixelCenters(Boolean halfPixelCenters) {
            this.halfPixelCenters = halfPixelCenters;
            return this;
        }

        private Options() {
        }
    }
}

