/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.util.function.Consumer;
import org.tensorflow.DataType;
import org.tensorflow.Tensor;
import org.tensorflow.tools.Shape;
import org.tensorflow.tools.buffer.BooleanDataBuffer;
import org.tensorflow.tools.ndarray.BooleanNdArray;
import org.tensorflow.tools.ndarray.NdArray;
import org.tensorflow.tools.ndarray.StdArrays;
import org.tensorflow.types.TBoolImpl;
import org.tensorflow.types.family.TType;

public interface TBool
extends BooleanNdArray,
TType {
    public static final DataType<TBool> DTYPE = DataType.create("BOOL", 10, 1, TBoolImpl::mapTensor);

    public static Tensor<TBool> scalarOf(boolean value) {
        return Tensor.of(DTYPE, Shape.scalar(), data -> data.setBoolean(value, new long[0]));
    }

    public static Tensor<TBool> vectorOf(boolean ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return Tensor.of(DTYPE, Shape.of(values.length), data -> StdArrays.copyTo((BooleanNdArray)data, values));
    }

    public static Tensor<TBool> tensorOf(NdArray<Boolean> src) {
        return Tensor.of(DTYPE, src.shape(), src::copyTo);
    }

    public static Tensor<TBool> tensorOf(Shape shape) {
        return Tensor.of(DTYPE, shape);
    }

    public static Tensor<TBool> tensorOf(Shape shape, BooleanDataBuffer data) {
        return Tensor.of(DTYPE, shape, d -> d.write(data));
    }

    public static Tensor<TBool> tensorOf(Shape shape, Consumer<TBool> dataInit) {
        return Tensor.of(DTYPE, shape, dataInit);
    }
}

