/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl.nio;

import java.nio.FloatBuffer;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.DataStorageVisitor;
import org.tensorflow.tools.buffer.FloatDataBuffer;
import org.tensorflow.tools.buffer.impl.Validator;
import org.tensorflow.tools.buffer.impl.nio.AbstractNioDataBuffer;

final class FloatNioDataBuffer
extends AbstractNioDataBuffer<Float>
implements FloatDataBuffer {
    private FloatBuffer buf;

    @Override
    public float getFloat(long index) {
        return this.buf.get((int)index);
    }

    @Override
    public FloatDataBuffer setFloat(float value, long index) {
        this.buf.put((int)index, value);
        return this;
    }

    @Override
    public FloatDataBuffer read(float[] dst, int offset, int length) {
        this.buf.duplicate().get(dst, offset, length);
        return this;
    }

    @Override
    public FloatDataBuffer write(float[] src, int offset, int length) {
        this.buf.duplicate().put(src, offset, length);
        return this;
    }

    @Override
    public FloatDataBuffer copyTo(final DataBuffer<Float> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return dst.accept(new DataStorageVisitor<FloatDataBuffer>(){

            @Override
            public FloatDataBuffer visit(FloatBuffer buffer) {
                buffer.duplicate().put((FloatBuffer)FloatNioDataBuffer.this.buf.duplicate().limit((int)size));
                return FloatNioDataBuffer.this;
            }

            @Override
            public FloatDataBuffer fallback() {
                if (dst instanceof FloatDataBuffer) {
                    FloatDataBuffer floatDst = (FloatDataBuffer)dst;
                    for (long idx = 0L; idx < size; ++idx) {
                        floatDst.setFloat(FloatNioDataBuffer.this.getFloat(idx), idx);
                    }
                    return FloatNioDataBuffer.this;
                }
                return (FloatDataBuffer)FloatNioDataBuffer.this.slowCopyTo(dst, size);
            }
        });
    }

    @Override
    public FloatDataBuffer offset(long index) {
        Validator.offsetArgs(this, index);
        return new FloatNioDataBuffer(((FloatBuffer)this.buf.duplicate().position((int)index)).slice());
    }

    @Override
    public FloatDataBuffer narrow(long size) {
        Validator.narrowArgs(this, size);
        return new FloatNioDataBuffer(((FloatBuffer)this.buf.duplicate().limit((int)size)).slice());
    }

    @Override
    public FloatDataBuffer slice(long index, long size) {
        Validator.sliceArgs(this, index, size);
        FloatBuffer sliceBuf = this.buf.duplicate();
        sliceBuf.position((int)index);
        sliceBuf.limit((int)index + (int)size);
        return new FloatNioDataBuffer(sliceBuf.slice());
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        return visitor.visit(this.buf);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FloatDataBuffer)) {
            return super.equals(obj);
        }
        final FloatDataBuffer other = (FloatDataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(FloatBuffer buffer) {
                return FloatNioDataBuffer.this.buf.equals(buffer);
            }

            @Override
            public Boolean fallback() {
                int idx = 0;
                while ((long)idx < FloatNioDataBuffer.this.size()) {
                    if (other.getFloat(idx) != FloatNioDataBuffer.this.getFloat(idx)) {
                        return false;
                    }
                    ++idx;
                }
                return true;
            }
        });
    }

    @Override
    FloatBuffer buf() {
        return this.buf;
    }

    FloatNioDataBuffer(FloatBuffer buf) {
        this.buf = buf;
    }
}

