/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

public final class CudnnRnnParamsSize<U extends TNumber>
extends RawOp
implements Operand<U> {
    private Output<U> paramsSize;

    public static <U extends TNumber, T extends TNumber> CudnnRnnParamsSize<U> create(Scope scope, Operand<TInt32> numLayers, Operand<TInt32> numUnits, Operand<TInt32> inputSize, DataType<T> T, DataType<U> S, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("CudnnRNNParamsSize", scope.makeOpName("CudnnRnnParamsSize"));
        opBuilder.addInput(numLayers.asOutput());
        opBuilder.addInput(numUnits.asOutput());
        opBuilder.addInput(inputSize.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("T", T);
        opBuilder.setAttr("S", S);
        if (options != null) {
            for (Options opts : options) {
                if (opts.rnnMode != null) {
                    opBuilder.setAttr("rnn_mode", opts.rnnMode);
                }
                if (opts.inputMode != null) {
                    opBuilder.setAttr("input_mode", opts.inputMode);
                }
                if (opts.direction != null) {
                    opBuilder.setAttr("direction", opts.direction);
                }
                if (opts.dropout != null) {
                    opBuilder.setAttr("dropout", opts.dropout.floatValue());
                }
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 != null) {
                    opBuilder.setAttr("seed2", opts.seed2);
                }
                if (opts.numProj == null) continue;
                opBuilder.setAttr("num_proj", opts.numProj);
            }
        }
        return new CudnnRnnParamsSize<U>(opBuilder.build());
    }

    public static Options rnnMode(String rnnMode) {
        return new Options().rnnMode(rnnMode);
    }

    public static Options inputMode(String inputMode) {
        return new Options().inputMode(inputMode);
    }

    public static Options direction(String direction) {
        return new Options().direction(direction);
    }

    public static Options dropout(Float dropout) {
        return new Options().dropout(dropout);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public static Options numProj(Long numProj) {
        return new Options().numProj(numProj);
    }

    public Output<U> paramsSize() {
        return this.paramsSize;
    }

    @Override
    public Output<U> asOutput() {
        return this.paramsSize;
    }

    private CudnnRnnParamsSize(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.paramsSize = operation.output(outputIdx++);
    }

    public static class Options {
        private String rnnMode;
        private String inputMode;
        private String direction;
        private Float dropout;
        private Long seed;
        private Long seed2;
        private Long numProj;

        public Options rnnMode(String rnnMode) {
            this.rnnMode = rnnMode;
            return this;
        }

        public Options inputMode(String inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        public Options direction(String direction) {
            this.direction = direction;
            return this;
        }

        public Options dropout(Float dropout) {
            this.dropout = dropout;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        public Options numProj(Long numProj) {
            this.numProj = numProj;
            return this;
        }

        private Options() {
        }
    }
}

