/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.ndarray.impl.sequence;

import java.util.Iterator;
import java.util.function.BiConsumer;
import org.tensorflow.tools.ndarray.IllegalRankException;
import org.tensorflow.tools.ndarray.NdArray;
import org.tensorflow.tools.ndarray.NdArraySequence;
import org.tensorflow.tools.ndarray.impl.AbstractNdArray;

class SingleElementSequence<T, U extends NdArray<T>>
implements NdArraySequence<U> {
    private final AbstractNdArray<T, U> ndArray;

    @Override
    public Iterator<U> iterator() {
        return new Iterator<U>(){
            private U element;
            {
                this.element = SingleElementSequence.this.ndArray;
            }

            @Override
            public boolean hasNext() {
                return this.element != null;
            }

            @Override
            public U next() {
                Object ret = this.element;
                this.element = null;
                return ret;
            }
        };
    }

    @Override
    public void forEachIndexed(BiConsumer<long[], U> consumer) {
        throw new IllegalRankException("Single element has no coordinates to iterate on, use forEach()");
    }

    SingleElementSequence(AbstractNdArray<T, U> ndArray) {
        this.ndArray = ndArray;
    }
}

