/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.ndarray.impl;

import java.util.Iterator;
import org.tensorflow.tools.Shape;
import org.tensorflow.tools.ndarray.NdArray;
import org.tensorflow.tools.ndarray.NdArraySequence;
import org.tensorflow.tools.ndarray.impl.dimension.DimensionalSpace;
import org.tensorflow.tools.ndarray.impl.sequence.ElementSequence;

public abstract class AbstractNdArray<T, U extends NdArray<T>>
implements NdArray<T> {
    private DimensionalSpace dimensions;

    public abstract U slice(long var1, DimensionalSpace var3);

    public DimensionalSpace dimensions() {
        return this.dimensions;
    }

    @Override
    public Shape shape() {
        return this.dimensions.shape();
    }

    @Override
    public NdArraySequence<U> elements(int dimensionIdx) {
        if (dimensionIdx >= this.shape().numDimensions()) {
            throw new IllegalArgumentException("Cannot iterate elements in dimension '" + dimensionIdx + "' of array with shape " + this.shape());
        }
        return ElementSequence.create(this, dimensionIdx);
    }

    @Override
    public NdArraySequence<U> scalars() {
        return ElementSequence.create(this, this.shape().numDimensions() - 1);
    }

    public int hashCode() {
        return this.slowHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NdArray)) {
            return false;
        }
        return this.slowEquals((NdArray)obj);
    }

    protected AbstractNdArray(DimensionalSpace dimensions) {
        this.dimensions = dimensions;
    }

    protected void slowCopyTo(NdArray<T> array) {
        this.scalars().forEachIndexed((coords, e) -> array.setObject(e.getObject(new long[0]), (long)coords));
    }

    protected int slowHashCode() {
        int prime = 31;
        int result = 1;
        for (NdArray scalar : this.scalars()) {
            result = 31 * result + scalar.getObject(new long[0]).hashCode();
        }
        result = 31 * result + this.shape().hashCode();
        return result;
    }

    protected boolean slowEquals(NdArray<?> array) {
        if (!this.shape().equals(array.shape())) {
            return false;
        }
        Iterator thisIter = this.scalars().iterator();
        Iterator otherIter = array.scalars().iterator();
        while (thisIter.hasNext()) {
            if (((NdArray)thisIter.next()).getObject(new long[0]).equals(((NdArray)otherIter.next()).getObject(new long[0]))) continue;
            return false;
        }
        return true;
    }
}

