/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.tools.buffer.impl.raw;

import java.nio.ByteBuffer;
import org.tensorflow.tools.buffer.BooleanDataBuffer;
import org.tensorflow.tools.buffer.ByteDataBuffer;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.DataStorageVisitor;
import org.tensorflow.tools.buffer.DoubleDataBuffer;
import org.tensorflow.tools.buffer.FloatDataBuffer;
import org.tensorflow.tools.buffer.IntDataBuffer;
import org.tensorflow.tools.buffer.LongDataBuffer;
import org.tensorflow.tools.buffer.ShortDataBuffer;
import org.tensorflow.tools.buffer.impl.Validator;
import org.tensorflow.tools.buffer.impl.raw.AbstractRawDataBuffer;
import org.tensorflow.tools.buffer.impl.raw.BooleanRawDataBuffer;
import org.tensorflow.tools.buffer.impl.raw.DoubleRawDataBuffer;
import org.tensorflow.tools.buffer.impl.raw.FloatRawDataBuffer;
import org.tensorflow.tools.buffer.impl.raw.IntRawDataBuffer;
import org.tensorflow.tools.buffer.impl.raw.LongRawDataBuffer;
import org.tensorflow.tools.buffer.impl.raw.ShortRawDataBuffer;
import org.tensorflow.tools.buffer.impl.raw.UnsafeMemoryHandle;

final class ByteRawDataBuffer
extends AbstractRawDataBuffer<Byte, ByteDataBuffer>
implements ByteDataBuffer {
    @Override
    public byte getByte(long index) {
        Validator.getArgs(this, index);
        return this.memory.getByte(index);
    }

    @Override
    public ByteDataBuffer setByte(byte value, long index) {
        Validator.setArgs(this, index);
        this.memory.setByte(value, index);
        return this;
    }

    @Override
    public ByteDataBuffer read(byte[] dst) {
        return (ByteDataBuffer)this.read(dst, dst.length);
    }

    @Override
    public ByteDataBuffer read(byte[] dst, int offset, int length) {
        return (ByteDataBuffer)this.read(dst, dst.length, offset, length);
    }

    @Override
    public ByteDataBuffer write(byte[] src) {
        return (ByteDataBuffer)this.write(src, src.length);
    }

    @Override
    public ByteDataBuffer write(byte[] src, int offset, int length) {
        return (ByteDataBuffer)this.write(src, src.length, offset, length);
    }

    @Override
    public ByteDataBuffer copyTo(final DataBuffer<Byte> dst, final long size) {
        Validator.copyToArgs(this, dst, size);
        return dst.accept(new DataStorageVisitor<ByteDataBuffer>(){

            @Override
            public ByteDataBuffer visit(ByteBuffer buffer) {
                if (buffer.hasArray()) {
                    ByteRawDataBuffer.this.memory.copyTo(UnsafeMemoryHandle.fromArray(buffer.array(), buffer.position(), buffer.capacity()), size);
                } else if (ByteRawDataBuffer.this.memory.isArray()) {
                    buffer.put(ByteRawDataBuffer.this.memory.toArrayByteBuffer());
                } else {
                    ByteRawDataBuffer.this.slowCopyTo(dst, size);
                }
                return ByteRawDataBuffer.this;
            }

            @Override
            public ByteDataBuffer visit(long address, long length, long scale) {
                ByteRawDataBuffer.this.memory.copyTo(UnsafeMemoryHandle.fromAddress(address, length, scale), size);
                return ByteRawDataBuffer.this;
            }

            @Override
            public ByteDataBuffer fallback() {
                if (dst instanceof ByteDataBuffer) {
                    ByteDataBuffer byteDst = (ByteDataBuffer)dst;
                    for (long idx = 0L; idx < size; ++idx) {
                        byteDst.setByte(ByteRawDataBuffer.this.getByte(idx), idx);
                    }
                    return ByteRawDataBuffer.this;
                }
                return (ByteDataBuffer)ByteRawDataBuffer.this.slowCopyTo(dst, size);
            }
        });
    }

    @Override
    public IntDataBuffer asInts() {
        return new IntRawDataBuffer(this.memory.rescale(4L), this.readOnly);
    }

    @Override
    public ShortDataBuffer asShorts() {
        return new ShortRawDataBuffer(this.memory.rescale(2L), this.readOnly);
    }

    @Override
    public LongDataBuffer asLongs() {
        return new LongRawDataBuffer(this.memory.rescale(8L), this.readOnly);
    }

    @Override
    public FloatDataBuffer asFloats() {
        return new FloatRawDataBuffer(this.memory.rescale(4L), this.readOnly);
    }

    @Override
    public DoubleDataBuffer asDoubles() {
        return new DoubleRawDataBuffer(this.memory.rescale(8L), this.readOnly);
    }

    @Override
    public BooleanDataBuffer asBooleans() {
        return new BooleanRawDataBuffer(this.memory.rescale(1L), this.readOnly);
    }

    @Override
    public <R> R accept(DataStorageVisitor<R> visitor) {
        if (this.memory.isArray()) {
            return visitor.visit(this.memory.toArrayByteBuffer());
        }
        return visitor.visit(this.memory.byteOffset, this.memory.byteSize, this.memory.scale);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ByteDataBuffer)) {
            return super.equals(obj);
        }
        final ByteDataBuffer other = (ByteDataBuffer)obj;
        if (this.size() != other.size()) {
            return false;
        }
        return other.accept(new DataStorageVisitor<Boolean>(){

            @Override
            public Boolean visit(ByteBuffer buffer) {
                if (ByteRawDataBuffer.this.memory.isArray()) {
                    return buffer.equals(ByteRawDataBuffer.this.memory.toArrayByteBuffer());
                }
                return this.fallback();
            }

            @Override
            public Boolean fallback() {
                for (long idx = 0L; idx < ByteRawDataBuffer.this.size(); ++idx) {
                    if (other.getByte(idx) == ByteRawDataBuffer.this.getByte(idx)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    protected ByteDataBuffer instantiate(UnsafeMemoryHandle memory) {
        return new ByteRawDataBuffer(memory, this.readOnly);
    }

    ByteRawDataBuffer(UnsafeMemoryHandle memory, boolean readOnly) {
        super(memory, readOnly);
    }
}

