/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.linalg.sparse;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

public final class CSRSparseMatrixToSparseTensor<T extends TType>
extends RawOp {
    private Output<TInt64> indices;
    private Output<T> values;
    private Output<TInt64> denseShape;

    public static <T extends TType> CSRSparseMatrixToSparseTensor<T> create(Scope scope, Operand<?> sparseMatrix, DataType<T> type) {
        OperationBuilder opBuilder = scope.env().opBuilder("CSRSparseMatrixToSparseTensor", scope.makeOpName("CSRSparseMatrixToSparseTensor"));
        opBuilder.addInput(sparseMatrix.asOutput());
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("type", type);
        return new CSRSparseMatrixToSparseTensor<T>(opBuilder.build());
    }

    public Output<TInt64> indices() {
        return this.indices;
    }

    public Output<T> values() {
        return this.values;
    }

    public Output<TInt64> denseShape() {
        return this.denseShape;
    }

    private CSRSparseMatrixToSparseTensor(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.indices = operation.output(outputIdx++);
        this.values = operation.output(outputIdx++);
        this.denseShape = operation.output(outputIdx++);
    }
}

