/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.io;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.Scope;
import org.tensorflow.types.family.TType;

public final class FixedLengthRecordReader
extends RawOp
implements Operand<TType> {
    private Output<?> readerHandle;

    public static FixedLengthRecordReader create(Scope scope, Long recordBytes, Options ... options) {
        OperationBuilder opBuilder = scope.env().opBuilder("FixedLengthRecordReaderV2", scope.makeOpName("FixedLengthRecordReader"));
        opBuilder = scope.applyControlDependencies(opBuilder);
        opBuilder.setAttr("record_bytes", recordBytes);
        if (options != null) {
            for (Options opts : options) {
                if (opts.headerBytes != null) {
                    opBuilder.setAttr("header_bytes", opts.headerBytes);
                }
                if (opts.footerBytes != null) {
                    opBuilder.setAttr("footer_bytes", opts.footerBytes);
                }
                if (opts.hopBytes != null) {
                    opBuilder.setAttr("hop_bytes", opts.hopBytes);
                }
                if (opts.container != null) {
                    opBuilder.setAttr("container", opts.container);
                }
                if (opts.sharedName != null) {
                    opBuilder.setAttr("shared_name", opts.sharedName);
                }
                if (opts.encoding == null) continue;
                opBuilder.setAttr("encoding", opts.encoding);
            }
        }
        return new FixedLengthRecordReader(opBuilder.build());
    }

    public static Options headerBytes(Long headerBytes) {
        return new Options().headerBytes(headerBytes);
    }

    public static Options footerBytes(Long footerBytes) {
        return new Options().footerBytes(footerBytes);
    }

    public static Options hopBytes(Long hopBytes) {
        return new Options().hopBytes(hopBytes);
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options encoding(String encoding) {
        return new Options().encoding(encoding);
    }

    public Output<?> readerHandle() {
        return this.readerHandle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.readerHandle;
    }

    private FixedLengthRecordReader(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.readerHandle = operation.output(outputIdx++);
    }

    public static class Options {
        private Long headerBytes;
        private Long footerBytes;
        private Long hopBytes;
        private String container;
        private String sharedName;
        private String encoding;

        public Options headerBytes(Long headerBytes) {
            this.headerBytes = headerBytes;
            return this;
        }

        public Options footerBytes(Long footerBytes) {
            this.footerBytes = footerBytes;
            return this;
        }

        public Options hopBytes(Long hopBytes) {
            this.hopBytes = hopBytes;
            return this;
        }

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        private Options() {
        }
    }
}

