/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.op.Scope;
import org.tensorflow.op.random.AllCandidateSampler;
import org.tensorflow.op.random.LogUniformCandidateSampler;
import org.tensorflow.op.random.Multinomial;
import org.tensorflow.op.random.ParameterizedTruncatedNormal;
import org.tensorflow.op.random.RandomGamma;
import org.tensorflow.op.random.RandomPoisson;
import org.tensorflow.op.random.RandomShuffle;
import org.tensorflow.op.random.RandomStandardNormal;
import org.tensorflow.op.random.RandomUniform;
import org.tensorflow.op.random.RandomUniformInt;
import org.tensorflow.op.random.RecordInput;
import org.tensorflow.op.random.StatefulRandomBinomial;
import org.tensorflow.op.random.StatefulStandardNormal;
import org.tensorflow.op.random.StatelessMultinomial;
import org.tensorflow.op.random.StatelessRandomNormal;
import org.tensorflow.op.random.StatelessRandomUniform;
import org.tensorflow.op.random.StatelessTruncatedNormal;
import org.tensorflow.op.random.TruncatedNormal;
import org.tensorflow.op.random.UniformCandidateSampler;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

public final class RandomOps {
    private final Scope scope;

    RandomOps(Scope scope) {
        this.scope = scope;
    }

    public AllCandidateSampler allCandidateSampler(Operand<TInt64> trueClasses, Long numTrue, Long numSampled, Boolean unique, AllCandidateSampler.Options ... options) {
        return AllCandidateSampler.create(this.scope, trueClasses, numTrue, numSampled, unique, options);
    }

    public LogUniformCandidateSampler logUniformCandidateSampler(Operand<TInt64> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, LogUniformCandidateSampler.Options ... options) {
        return LogUniformCandidateSampler.create(this.scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
    }

    public <T extends TNumber> Multinomial<TInt64> multinomial(Operand<T> logits, Operand<TInt32> numSamples, Multinomial.Options ... options) {
        return Multinomial.create(this.scope, logits, numSamples, options);
    }

    public <U extends TNumber, T extends TNumber> Multinomial<U> multinomial(Operand<T> logits, Operand<TInt32> numSamples, DataType<U> outputDtype, Multinomial.Options ... options) {
        return Multinomial.create(this.scope, logits, numSamples, outputDtype, options);
    }

    public <U extends TNumber, T extends TNumber> ParameterizedTruncatedNormal<U> parameterizedTruncatedNormal(Operand<T> shape, Operand<U> means, Operand<U> stdevs, Operand<U> minvals, Operand<U> maxvals, ParameterizedTruncatedNormal.Options ... options) {
        return ParameterizedTruncatedNormal.create(this.scope, shape, means, stdevs, minvals, maxvals, options);
    }

    public <U extends TNumber, T extends TNumber> RandomGamma<U> randomGamma(Operand<T> shape, Operand<U> alpha, RandomGamma.Options ... options) {
        return RandomGamma.create(this.scope, shape, alpha, options);
    }

    public <T extends TNumber, U extends TNumber> RandomPoisson<TInt64> randomPoisson(Operand<T> shape, Operand<U> rate, RandomPoisson.Options ... options) {
        return RandomPoisson.create(this.scope, shape, rate, options);
    }

    public <V extends TNumber, T extends TNumber, U extends TNumber> RandomPoisson<V> randomPoisson(Operand<T> shape, Operand<U> rate, DataType<V> dtype, RandomPoisson.Options ... options) {
        return RandomPoisson.create(this.scope, shape, rate, dtype, options);
    }

    public <T extends TType> RandomShuffle<T> randomShuffle(Operand<T> value, RandomShuffle.Options ... options) {
        return RandomShuffle.create(this.scope, value, options);
    }

    public <U extends TNumber, T extends TNumber> RandomStandardNormal<U> randomStandardNormal(Operand<T> shape, DataType<U> dtype, RandomStandardNormal.Options ... options) {
        return RandomStandardNormal.create(this.scope, shape, dtype, options);
    }

    public <U extends TNumber, T extends TNumber> RandomUniform<U> randomUniform(Operand<T> shape, DataType<U> dtype, RandomUniform.Options ... options) {
        return RandomUniform.create(this.scope, shape, dtype, options);
    }

    public <U extends TNumber, T extends TNumber> RandomUniformInt<U> randomUniformInt(Operand<T> shape, Operand<U> minval, Operand<U> maxval, RandomUniformInt.Options ... options) {
        return RandomUniformInt.create(this.scope, shape, minval, maxval, options);
    }

    public RecordInput recordInput(String filePattern, RecordInput.Options ... options) {
        return RecordInput.create(this.scope, filePattern, options);
    }

    public <T extends TNumber, U extends TNumber> StatefulRandomBinomial<TInt64> statefulRandomBinomial(Operand<?> resource, Operand<TInt64> algorithm, Operand<T> shape, Operand<U> counts, Operand<U> probs) {
        return StatefulRandomBinomial.create(this.scope, resource, algorithm, shape, counts, probs);
    }

    public <V extends TNumber, T extends TNumber, U extends TNumber> StatefulRandomBinomial<V> statefulRandomBinomial(Operand<?> resource, Operand<TInt64> algorithm, Operand<T> shape, Operand<U> counts, Operand<U> probs, DataType<V> dtype) {
        return StatefulRandomBinomial.create(this.scope, resource, algorithm, shape, counts, probs, dtype);
    }

    public <T extends TType> StatefulStandardNormal<TFloat32> statefulStandardNormal(Operand<?> resource, Operand<TInt64> algorithm, Operand<T> shape) {
        return StatefulStandardNormal.create(this.scope, resource, algorithm, shape);
    }

    public <U extends TType, T extends TType> StatefulStandardNormal<U> statefulStandardNormal(Operand<?> resource, Operand<TInt64> algorithm, Operand<T> shape, DataType<U> dtype) {
        return StatefulStandardNormal.create(this.scope, resource, algorithm, shape, dtype);
    }

    public <T extends TNumber, U extends TNumber> StatelessMultinomial<TInt64> statelessMultinomial(Operand<T> logits, Operand<TInt32> numSamples, Operand<U> seed) {
        return StatelessMultinomial.create(this.scope, logits, numSamples, seed);
    }

    public <V extends TNumber, T extends TNumber, U extends TNumber> StatelessMultinomial<V> statelessMultinomial(Operand<T> logits, Operand<TInt32> numSamples, Operand<U> seed, DataType<V> outputDtype) {
        return StatelessMultinomial.create(this.scope, logits, numSamples, seed, outputDtype);
    }

    public <T extends TNumber, U extends TNumber> StatelessRandomNormal<TFloat32> statelessRandomNormal(Operand<T> shape, Operand<U> seed) {
        return StatelessRandomNormal.create(this.scope, shape, seed);
    }

    public <V extends TNumber, T extends TNumber, U extends TNumber> StatelessRandomNormal<V> statelessRandomNormal(Operand<T> shape, Operand<U> seed, DataType<V> dtype) {
        return StatelessRandomNormal.create(this.scope, shape, seed, dtype);
    }

    public <T extends TNumber, U extends TNumber> StatelessRandomUniform<TFloat32> statelessRandomUniform(Operand<T> shape, Operand<U> seed) {
        return StatelessRandomUniform.create(this.scope, shape, seed);
    }

    public <V extends TNumber, T extends TNumber, U extends TNumber> StatelessRandomUniform<V> statelessRandomUniform(Operand<T> shape, Operand<U> seed, DataType<V> dtype) {
        return StatelessRandomUniform.create(this.scope, shape, seed, dtype);
    }

    public <T extends TNumber, U extends TNumber> StatelessTruncatedNormal<TFloat32> statelessTruncatedNormal(Operand<T> shape, Operand<U> seed) {
        return StatelessTruncatedNormal.create(this.scope, shape, seed);
    }

    public <V extends TNumber, T extends TNumber, U extends TNumber> StatelessTruncatedNormal<V> statelessTruncatedNormal(Operand<T> shape, Operand<U> seed, DataType<V> dtype) {
        return StatelessTruncatedNormal.create(this.scope, shape, seed, dtype);
    }

    public <U extends TNumber, T extends TNumber> TruncatedNormal<U> truncatedNormal(Operand<T> shape, DataType<U> dtype, TruncatedNormal.Options ... options) {
        return TruncatedNormal.create(this.scope, shape, dtype, options);
    }

    public UniformCandidateSampler uniformCandidateSampler(Operand<TInt64> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, UniformCandidateSampler.Options ... options) {
        return UniformCandidateSampler.create(this.scope, trueClasses, numTrue, numSampled, unique, rangeMax, options);
    }
}

