/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.buffer;

import java.nio.ReadOnlyBufferException;
import java.util.function.Function;
import org.tensorflow.tools.buffer.ByteDataBuffer;
import org.tensorflow.tools.buffer.DataBuffer;
import org.tensorflow.tools.buffer.LongDataBuffer;
import org.tensorflow.tools.buffer.impl.AbstractDataBuffer;
import org.tensorflow.tools.buffer.impl.Validator;
import org.tensorflow.tools.ndarray.NdArray;

public class StringTensorBuffer
extends AbstractDataBuffer<byte[]> {
    private final LongDataBuffer offsets;
    private final ByteDataBuffer data;

    public static <T> long computeSize(NdArray<T> data, Function<T, byte[]> getBytes) {
        long size = data.size() * 8L;
        for (NdArray ndArray : data.scalars()) {
            byte[] elementBytes = getBytes.apply(ndArray.getObject(new long[0]));
            size += (long)(elementBytes.length + StringTensorBuffer.varintLength(elementBytes.length));
        }
        return size;
    }

    public <T> void init(NdArray<T> data, Function<T, byte[]> getBytes) {
        InitDataWriter writer = new InitDataWriter();
        for (NdArray ndArray : data.scalars()) {
            writer.writeNext(getBytes.apply(ndArray.getObject(new long[0])));
        }
    }

    @Override
    public long size() {
        return this.offsets.size();
    }

    @Override
    public byte[] getObject(long index) {
        byte b;
        Validator.getArgs(this, index);
        long offset = this.offsets.getLong(index);
        int pos = 0;
        int length = 0;
        do {
            b = this.data.getByte(offset++);
            length |= (b & 0x7F) << pos++;
        } while ((b & 0x80) != 0);
        byte[] bytes = new byte[length];
        if (length > 0) {
            this.data.offset(offset).read(bytes);
        }
        return bytes;
    }

    @Override
    public DataBuffer<byte[]> setObject(byte[] values, long index) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public DataBuffer<byte[]> copyTo(DataBuffer<byte[]> dst, long size) {
        if (size == this.size() && dst instanceof StringTensorBuffer) {
            StringTensorBuffer tensorDst = (StringTensorBuffer)dst;
            if (this.offsets.size() != size || this.data.size() != size) {
                throw new IllegalArgumentException("Cannot copy string tensor data to another tensor of a different size");
            }
            this.offsets.copyTo((DataBuffer)tensorDst.offsets, size);
            this.data.copyTo((DataBuffer)tensorDst.data, size);
        } else {
            this.slowCopyTo(dst, size);
        }
        return this;
    }

    @Override
    public DataBuffer<byte[]> offset(long index) {
        return new StringTensorBuffer(this.offsets.offset(index), this.data);
    }

    @Override
    public DataBuffer<byte[]> narrow(long size) {
        return new StringTensorBuffer(this.offsets.narrow(size), this.data);
    }

    @Override
    public DataBuffer<byte[]> slice(long index, long size) {
        return new StringTensorBuffer(this.offsets.slice(index, size), this.data);
    }

    StringTensorBuffer(LongDataBuffer offsets, ByteDataBuffer data) {
        this.offsets = offsets;
        this.data = data;
    }

    private static int varintLength(int length) {
        int len = 1;
        while (length >= 128) {
            length >>= 7;
            ++len;
        }
        return len;
    }

    private class InitDataWriter {
        long offsetIndex = 0L;
        long dataIndex = 0L;

        private InitDataWriter() {
        }

        void writeNext(byte[] bytes) {
            int v;
            StringTensorBuffer.this.offsets.setLong(this.dataIndex, this.offsetIndex++);
            for (v = bytes.length; v >= 128; v >>= 7) {
                StringTensorBuffer.this.data.setByte((byte)(v & 0x7F | 0x80), this.dataIndex++);
            }
            StringTensorBuffer.this.data.setByte((byte)v, this.dataIndex++);
            StringTensorBuffer.this.data.offset(this.dataIndex).write(bytes);
            this.dataIndex += (long)bytes.length;
        }
    }
}

