/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.types;

import java.util.function.Consumer;
import org.tensorflow.SparseTensor;
import org.tensorflow.Tensor;
import org.tensorflow.internal.types.TBoolMapper;
import org.tensorflow.ndarray.BooleanNdArray;
import org.tensorflow.ndarray.NdArray;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.ndarray.StdArrays;
import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.annotation.TensorType;
import org.tensorflow.types.family.TType;

@TensorType(dataType=DataType.DT_BOOL, byteSize=1, mapperClass=TBoolMapper.class)
public interface TBool
extends BooleanNdArray,
TType {
    public static TBool scalarOf(boolean value) {
        return Tensor.of(TBool.class, Shape.scalar(), (T data) -> data.setBoolean(value, new long[0]));
    }

    public static TBool vectorOf(boolean ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        return Tensor.of(TBool.class, Shape.of(values.length), (T data) -> StdArrays.copyTo(values, (BooleanNdArray)data));
    }

    public static TBool tensorOf(NdArray<Boolean> src) {
        return Tensor.of(TBool.class, src.shape(), src::copyTo);
    }

    public static TBool tensorOf(Shape shape) {
        return Tensor.of(TBool.class, shape);
    }

    public static TBool tensorOf(Shape shape, BooleanDataBuffer data) {
        return Tensor.of(TBool.class, shape, (T d) -> d.copyFrom(data));
    }

    public static TBool tensorOf(Shape shape, Consumer<TBool> dataInit) {
        return Tensor.of(TBool.class, shape, dataInit);
    }

    public static TBool sparseTensorOf(TInt64 indices, TBool values, TInt64 denseShape) {
        return SparseTensor.of(indices, values, denseShape).asTypedTensor();
    }
}

