/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="XlaSparseDenseMatmulGradWithFtrlAndCsrInput", inputsClass=Inputs.class)
public final class XlaSparseDenseMatmulGradWithFtrlAndCsrInput
extends RawOp {
    public static final String OP_NAME = "XlaSparseDenseMatmulGradWithFtrlAndCsrInput";
    private Output<TFloat32> updatedEmbeddingTable;
    private Output<TFloat32> updatedAccumulator;
    private Output<TFloat32> updatedLinear;

    public XlaSparseDenseMatmulGradWithFtrlAndCsrInput(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.updatedEmbeddingTable = operation.output(outputIdx++);
        this.updatedAccumulator = operation.output(outputIdx++);
        this.updatedLinear = operation.output(outputIdx++);
    }

    public static XlaSparseDenseMatmulGradWithFtrlAndCsrInput create(Scope scope, Operand<TInt32> rowPointers, Operand<TInt32> sortedSampleIds, Operand<TInt32> sortedTokenIds, Operand<TFloat32> sortedGains, Operand<TFloat32> activationGradients, Operand<TFloat32> learningRate, Operand<TFloat32> embeddingTable, Operand<TFloat32> accumulator, Operand<TFloat32> linear, Operand<TInt32> numMinibatchesPerPhysicalSparseCore, Boolean multiplyLinearByLearningRate, Float beta, Float learningRatePower, Float l1RegularizationStrength, Float l2RegularizationStrength, String tableName, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(rowPointers.asOutput());
        opBuilder.addInput(sortedSampleIds.asOutput());
        opBuilder.addInput(sortedTokenIds.asOutput());
        opBuilder.addInput(sortedGains.asOutput());
        opBuilder.addInput(activationGradients.asOutput());
        opBuilder.addInput(learningRate.asOutput());
        opBuilder.addInput(embeddingTable.asOutput());
        opBuilder.addInput(accumulator.asOutput());
        opBuilder.addInput(linear.asOutput());
        opBuilder.addInput(numMinibatchesPerPhysicalSparseCore.asOutput());
        opBuilder.setAttr("multiply_linear_by_learning_rate", multiplyLinearByLearningRate);
        opBuilder.setAttr("beta", beta.floatValue());
        opBuilder.setAttr("learning_rate_power", learningRatePower.floatValue());
        opBuilder.setAttr("l1_regularization_strength", l1RegularizationStrength.floatValue());
        opBuilder.setAttr("l2_regularization_strength", l2RegularizationStrength.floatValue());
        opBuilder.setAttr("table_name", tableName);
        if (options != null) {
            for (Options opts : options) {
                if (opts.clipWeightMin != null) {
                    opBuilder.setAttr("clip_weight_min", opts.clipWeightMin.floatValue());
                }
                if (opts.clipWeightMax == null) continue;
                opBuilder.setAttr("clip_weight_max", opts.clipWeightMax.floatValue());
            }
        }
        return new XlaSparseDenseMatmulGradWithFtrlAndCsrInput(opBuilder.build());
    }

    public static Options clipWeightMin(Float clipWeightMin) {
        return new Options().clipWeightMin(clipWeightMin);
    }

    public static Options clipWeightMax(Float clipWeightMax) {
        return new Options().clipWeightMax(clipWeightMax);
    }

    public Output<TFloat32> updatedEmbeddingTable() {
        return this.updatedEmbeddingTable;
    }

    public Output<TFloat32> updatedAccumulator() {
        return this.updatedAccumulator;
    }

    public Output<TFloat32> updatedLinear() {
        return this.updatedLinear;
    }

    @OpInputsMetadata(outputsClass=XlaSparseDenseMatmulGradWithFtrlAndCsrInput.class)
    public static class Inputs
    extends RawOpInputs<XlaSparseDenseMatmulGradWithFtrlAndCsrInput> {
        public final Operand<TInt32> rowPointers;
        public final Operand<TInt32> sortedSampleIds;
        public final Operand<TInt32> sortedTokenIds;
        public final Operand<TFloat32> sortedGains;
        public final Operand<TFloat32> activationGradients;
        public final Operand<TFloat32> learningRate;
        public final Operand<TFloat32> embeddingTable;
        public final Operand<TFloat32> accumulator;
        public final Operand<TFloat32> linear;
        public final Operand<TInt32> numMinibatchesPerPhysicalSparseCore;
        public final boolean multiplyLinearByLearningRate;
        public final float beta;
        public final float learningRatePower;
        public final float l1RegularizationStrength;
        public final float l2RegularizationStrength;
        public final float clipWeightMin;
        public final float clipWeightMax;
        public final String tableName;

        public Inputs(GraphOperation op) {
            super(new XlaSparseDenseMatmulGradWithFtrlAndCsrInput(op), op, Arrays.asList("multiply_linear_by_learning_rate", "beta", "learning_rate_power", "l1_regularization_strength", "l2_regularization_strength", "clip_weight_min", "clip_weight_max", "table_name"));
            int inputIndex = 0;
            this.rowPointers = op.input(inputIndex++);
            this.sortedSampleIds = op.input(inputIndex++);
            this.sortedTokenIds = op.input(inputIndex++);
            this.sortedGains = op.input(inputIndex++);
            this.activationGradients = op.input(inputIndex++);
            this.learningRate = op.input(inputIndex++);
            this.embeddingTable = op.input(inputIndex++);
            this.accumulator = op.input(inputIndex++);
            this.linear = op.input(inputIndex++);
            this.numMinibatchesPerPhysicalSparseCore = op.input(inputIndex++);
            this.multiplyLinearByLearningRate = op.attributes().getAttrBool("multiply_linear_by_learning_rate");
            this.beta = op.attributes().getAttrFloat("beta");
            this.learningRatePower = op.attributes().getAttrFloat("learning_rate_power");
            this.l1RegularizationStrength = op.attributes().getAttrFloat("l1_regularization_strength");
            this.l2RegularizationStrength = op.attributes().getAttrFloat("l2_regularization_strength");
            this.clipWeightMin = op.attributes().getAttrFloat("clip_weight_min");
            this.clipWeightMax = op.attributes().getAttrFloat("clip_weight_max");
            this.tableName = op.attributes().getAttrString("table_name");
        }
    }

    public static class Options {
        private Float clipWeightMin;
        private Float clipWeightMax;

        private Options() {
        }

        public Options clipWeightMin(Float clipWeightMin) {
            this.clipWeightMin = clipWeightMin;
            return this;
        }

        public Options clipWeightMax(Float clipWeightMax) {
            this.clipWeightMax = clipWeightMax;
            return this;
        }
    }
}

