/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="XlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInput", inputsClass=Inputs.class)
public final class XlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInput
extends RawOp {
    public static final String OP_NAME = "XlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInput";
    private Output<TFloat32> updatedEmbeddingTable;
    private Output<TFloat32> updatedAccumulator;
    private Output<TFloat32> updatedMomenta;

    public XlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInput(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.updatedEmbeddingTable = operation.output(outputIdx++);
        this.updatedAccumulator = operation.output(outputIdx++);
        this.updatedMomenta = operation.output(outputIdx++);
    }

    public static XlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInput create(Scope scope, Operand<TInt32> rowPointers, Operand<TInt32> sortedSampleIds, Operand<TInt32> sortedTokenIds, Operand<TFloat32> sortedGains, Operand<TFloat32> activationGradients, Operand<TFloat32> learningRate, Operand<TFloat32> embeddingTable, Operand<TFloat32> accumulator, Operand<TFloat32> momenta, Operand<TInt32> numMinibatchesPerPhysicalSparseCore, Boolean useNesterov, Float exponent, Float beta1, Float beta2, Float epsilon, String tableName, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(rowPointers.asOutput());
        opBuilder.addInput(sortedSampleIds.asOutput());
        opBuilder.addInput(sortedTokenIds.asOutput());
        opBuilder.addInput(sortedGains.asOutput());
        opBuilder.addInput(activationGradients.asOutput());
        opBuilder.addInput(learningRate.asOutput());
        opBuilder.addInput(embeddingTable.asOutput());
        opBuilder.addInput(accumulator.asOutput());
        opBuilder.addInput(momenta.asOutput());
        opBuilder.addInput(numMinibatchesPerPhysicalSparseCore.asOutput());
        opBuilder.setAttr("use_nesterov", useNesterov);
        opBuilder.setAttr("exponent", exponent.floatValue());
        opBuilder.setAttr("beta1", beta1.floatValue());
        opBuilder.setAttr("beta2", beta2.floatValue());
        opBuilder.setAttr("epsilon", epsilon.floatValue());
        opBuilder.setAttr("table_name", tableName);
        if (options != null) {
            for (Options opts : options) {
                if (opts.clipWeightMin != null) {
                    opBuilder.setAttr("clip_weight_min", opts.clipWeightMin.floatValue());
                }
                if (opts.clipWeightMax == null) continue;
                opBuilder.setAttr("clip_weight_max", opts.clipWeightMax.floatValue());
            }
        }
        return new XlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInput(opBuilder.build());
    }

    public static Options clipWeightMin(Float clipWeightMin) {
        return new Options().clipWeightMin(clipWeightMin);
    }

    public static Options clipWeightMax(Float clipWeightMax) {
        return new Options().clipWeightMax(clipWeightMax);
    }

    public Output<TFloat32> updatedEmbeddingTable() {
        return this.updatedEmbeddingTable;
    }

    public Output<TFloat32> updatedAccumulator() {
        return this.updatedAccumulator;
    }

    public Output<TFloat32> updatedMomenta() {
        return this.updatedMomenta;
    }

    @OpInputsMetadata(outputsClass=XlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInput.class)
    public static class Inputs
    extends RawOpInputs<XlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInput> {
        public final Operand<TInt32> rowPointers;
        public final Operand<TInt32> sortedSampleIds;
        public final Operand<TInt32> sortedTokenIds;
        public final Operand<TFloat32> sortedGains;
        public final Operand<TFloat32> activationGradients;
        public final Operand<TFloat32> learningRate;
        public final Operand<TFloat32> embeddingTable;
        public final Operand<TFloat32> accumulator;
        public final Operand<TFloat32> momenta;
        public final Operand<TInt32> numMinibatchesPerPhysicalSparseCore;
        public final boolean useNesterov;
        public final float exponent;
        public final float beta1;
        public final float beta2;
        public final float epsilon;
        public final float clipWeightMin;
        public final float clipWeightMax;
        public final String tableName;

        public Inputs(GraphOperation op) {
            super(new XlaSparseDenseMatmulGradWithAdagradMomentumAndCsrInput(op), op, Arrays.asList("use_nesterov", "exponent", "beta1", "beta2", "epsilon", "clip_weight_min", "clip_weight_max", "table_name"));
            int inputIndex = 0;
            this.rowPointers = op.input(inputIndex++);
            this.sortedSampleIds = op.input(inputIndex++);
            this.sortedTokenIds = op.input(inputIndex++);
            this.sortedGains = op.input(inputIndex++);
            this.activationGradients = op.input(inputIndex++);
            this.learningRate = op.input(inputIndex++);
            this.embeddingTable = op.input(inputIndex++);
            this.accumulator = op.input(inputIndex++);
            this.momenta = op.input(inputIndex++);
            this.numMinibatchesPerPhysicalSparseCore = op.input(inputIndex++);
            this.useNesterov = op.attributes().getAttrBool("use_nesterov");
            this.exponent = op.attributes().getAttrFloat("exponent");
            this.beta1 = op.attributes().getAttrFloat("beta1");
            this.beta2 = op.attributes().getAttrFloat("beta2");
            this.epsilon = op.attributes().getAttrFloat("epsilon");
            this.clipWeightMin = op.attributes().getAttrFloat("clip_weight_min");
            this.clipWeightMax = op.attributes().getAttrFloat("clip_weight_max");
            this.tableName = op.attributes().getAttrString("table_name");
        }
    }

    public static class Options {
        private Float clipWeightMin;
        private Float clipWeightMax;

        private Options() {
        }

        public Options clipWeightMin(Float clipWeightMin) {
            this.clipWeightMin = clipWeightMin;
            return this;
        }

        public Options clipWeightMax(Float clipWeightMax) {
            this.clipWeightMax = clipWeightMax;
            return this;
        }
    }
}

