/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt64;

@OpMetadata(opType="SdcaOptimizerV2", inputsClass=Inputs.class)
public final class SdcaOptimizer
extends RawOp {
    public static final String OP_NAME = "SdcaOptimizerV2";
    private Output<TFloat32> outExampleStateData;
    private List<Output<TFloat32>> outDeltaSparseWeights;
    private List<Output<TFloat32>> outDeltaDenseWeights;

    public SdcaOptimizer(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outExampleStateData = operation.output(outputIdx++);
        int outDeltaSparseWeightsLength = operation.outputListLength("out_delta_sparse_weights");
        this.outDeltaSparseWeights = Arrays.asList(operation.outputList(outputIdx, outDeltaSparseWeightsLength));
        int outDeltaDenseWeightsLength = operation.outputListLength("out_delta_dense_weights");
        this.outDeltaDenseWeights = Arrays.asList(operation.outputList(outputIdx += outDeltaSparseWeightsLength, outDeltaDenseWeightsLength));
        outputIdx += outDeltaDenseWeightsLength;
    }

    public static SdcaOptimizer create(Scope scope, Iterable<Operand<TInt64>> sparseExampleIndices, Iterable<Operand<TInt64>> sparseFeatureIndices, Iterable<Operand<TFloat32>> sparseFeatureValues, Iterable<Operand<TFloat32>> denseFeatures, Operand<TFloat32> exampleWeights, Operand<TFloat32> exampleLabels, Iterable<Operand<TInt64>> sparseIndices, Iterable<Operand<TFloat32>> sparseWeights, Iterable<Operand<TFloat32>> denseWeights, Operand<TFloat32> exampleStateData, String lossType, Float l1, Float l2, Long numLossPartitions, Long numInnerIterations, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "SdcaOptimizer");
        opBuilder.addInputList(Operands.asOutputs(sparseExampleIndices));
        opBuilder.addInputList(Operands.asOutputs(sparseFeatureIndices));
        opBuilder.addInputList(Operands.asOutputs(sparseFeatureValues));
        opBuilder.addInputList(Operands.asOutputs(denseFeatures));
        opBuilder.addInput(exampleWeights.asOutput());
        opBuilder.addInput(exampleLabels.asOutput());
        opBuilder.addInputList(Operands.asOutputs(sparseIndices));
        opBuilder.addInputList(Operands.asOutputs(sparseWeights));
        opBuilder.addInputList(Operands.asOutputs(denseWeights));
        opBuilder.addInput(exampleStateData.asOutput());
        opBuilder.setAttr("loss_type", lossType);
        opBuilder.setAttr("l1", l1.floatValue());
        opBuilder.setAttr("l2", l2.floatValue());
        opBuilder.setAttr("num_loss_partitions", numLossPartitions);
        opBuilder.setAttr("num_inner_iterations", numInnerIterations);
        if (options != null) {
            for (Options opts : options) {
                if (opts.adaptive == null) continue;
                opBuilder.setAttr("adaptive", opts.adaptive);
            }
        }
        return new SdcaOptimizer(opBuilder.build());
    }

    public static Options adaptive(Boolean adaptive) {
        return new Options().adaptive(adaptive);
    }

    public Output<TFloat32> outExampleStateData() {
        return this.outExampleStateData;
    }

    public List<Output<TFloat32>> outDeltaSparseWeights() {
        return this.outDeltaSparseWeights;
    }

    public List<Output<TFloat32>> outDeltaDenseWeights() {
        return this.outDeltaDenseWeights;
    }

    @OpInputsMetadata(outputsClass=SdcaOptimizer.class)
    public static class Inputs
    extends RawOpInputs<SdcaOptimizer> {
        public final Iterable<Operand<TInt64>> sparseExampleIndices;
        public final Iterable<Operand<TInt64>> sparseFeatureIndices;
        public final Iterable<Operand<TFloat32>> sparseFeatureValues;
        public final Iterable<Operand<TFloat32>> denseFeatures;
        public final Operand<TFloat32> exampleWeights;
        public final Operand<TFloat32> exampleLabels;
        public final Iterable<Operand<TInt64>> sparseIndices;
        public final Iterable<Operand<TFloat32>> sparseWeights;
        public final Iterable<Operand<TFloat32>> denseWeights;
        public final Operand<TFloat32> exampleStateData;
        public final String lossType;
        public final boolean adaptive;
        public final float l1;
        public final float l2;
        public final long numLossPartitions;
        public final long numInnerIterations;

        public Inputs(GraphOperation op) {
            super(new SdcaOptimizer(op), op, Arrays.asList("loss_type", "adaptive", "l1", "l2", "num_loss_partitions", "num_inner_iterations"));
            int inputIndex = 0;
            int sparseExampleIndicesLength = op.inputListLength("sparse_example_indices");
            this.sparseExampleIndices = Arrays.asList((Operand[])op.inputList(inputIndex, sparseExampleIndicesLength));
            int sparseFeatureIndicesLength = op.inputListLength("sparse_feature_indices");
            this.sparseFeatureIndices = Arrays.asList((Operand[])op.inputList(inputIndex += sparseExampleIndicesLength, sparseFeatureIndicesLength));
            int sparseFeatureValuesLength = op.inputListLength("sparse_feature_values");
            this.sparseFeatureValues = Arrays.asList((Operand[])op.inputList(inputIndex += sparseFeatureIndicesLength, sparseFeatureValuesLength));
            int denseFeaturesLength = op.inputListLength("dense_features");
            this.denseFeatures = Arrays.asList((Operand[])op.inputList(inputIndex += sparseFeatureValuesLength, denseFeaturesLength));
            inputIndex += denseFeaturesLength;
            this.exampleWeights = op.input(inputIndex++);
            this.exampleLabels = op.input(inputIndex++);
            int sparseIndicesLength = op.inputListLength("sparse_indices");
            this.sparseIndices = Arrays.asList((Operand[])op.inputList(inputIndex, sparseIndicesLength));
            int sparseWeightsLength = op.inputListLength("sparse_weights");
            this.sparseWeights = Arrays.asList((Operand[])op.inputList(inputIndex += sparseIndicesLength, sparseWeightsLength));
            int denseWeightsLength = op.inputListLength("dense_weights");
            this.denseWeights = Arrays.asList((Operand[])op.inputList(inputIndex += sparseWeightsLength, denseWeightsLength));
            inputIndex += denseWeightsLength;
            this.exampleStateData = op.input(inputIndex++);
            this.lossType = op.attributes().getAttrString("loss_type");
            this.adaptive = op.attributes().getAttrBool("adaptive");
            this.l1 = op.attributes().getAttrFloat("l1");
            this.l2 = op.attributes().getAttrFloat("l2");
            this.numLossPartitions = op.attributes().getAttrInt("num_loss_partitions");
            this.numInnerIterations = op.attributes().getAttrInt("num_inner_iterations");
        }
    }

    public static class Options {
        private Boolean adaptive;

        private Options() {
        }

        public Options adaptive(Boolean adaptive) {
            this.adaptive = adaptive;
            return this;
        }
    }
}

