/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="NegTrain", inputsClass=Inputs.class)
public final class NegTrain
extends RawOp {
    public static final String OP_NAME = "NegTrain";

    public NegTrain(Operation operation) {
        super(operation, OP_NAME);
    }

    public static NegTrain create(Scope scope, Operand<TFloat32> wIn, Operand<TFloat32> wOut, Operand<TInt32> examples, Operand<TInt32> labels, Operand<TFloat32> lr, List<Long> vocabCount, Long numNegativeSamples) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(wIn.asOutput());
        opBuilder.addInput(wOut.asOutput());
        opBuilder.addInput(examples.asOutput());
        opBuilder.addInput(labels.asOutput());
        opBuilder.addInput(lr.asOutput());
        long[] vocabCountArray = new long[vocabCount.size()];
        for (int i = 0; i < vocabCountArray.length; ++i) {
            vocabCountArray[i] = vocabCount.get(i);
        }
        opBuilder.setAttr("vocab_count", vocabCountArray);
        opBuilder.setAttr("num_negative_samples", numNegativeSamples);
        return new NegTrain(opBuilder.build());
    }

    @OpInputsMetadata(outputsClass=NegTrain.class)
    public static class Inputs
    extends RawOpInputs<NegTrain> {
        public final Operand<TFloat32> wIn;
        public final Operand<TFloat32> wOut;
        public final Operand<TInt32> examples;
        public final Operand<TInt32> labels;
        public final Operand<TFloat32> lr;
        public final long[] vocabCount;
        public final long numNegativeSamples;

        public Inputs(GraphOperation op) {
            super(new NegTrain(op), op, Arrays.asList("vocab_count", "num_negative_samples"));
            int inputIndex = 0;
            this.wIn = op.input(inputIndex++);
            this.wOut = op.input(inputIndex++);
            this.examples = op.input(inputIndex++);
            this.labels = op.input(inputIndex++);
            this.lr = op.input(inputIndex++);
            this.vocabCount = op.attributes().getAttrIntList("vocab_count");
            this.numNegativeSamples = op.attributes().getAttrInt("num_negative_samples");
        }
    }
}

