/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ApplyMomentum", inputsClass=Inputs.class)
public final class ApplyMomentum<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "ApplyMomentum";
    private Output<T> out;

    public ApplyMomentum(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.out = operation.output(outputIdx++);
    }

    public static <T extends TType> ApplyMomentum<T> create(Scope scope, Operand<T> var, Operand<T> accum, Operand<T> lr, Operand<T> grad, Operand<T> momentum, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(var.asOutput());
        opBuilder.addInput(accum.asOutput());
        opBuilder.addInput(lr.asOutput());
        opBuilder.addInput(grad.asOutput());
        opBuilder.addInput(momentum.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.useLocking != null) {
                    opBuilder.setAttr("use_locking", opts.useLocking);
                }
                if (opts.useNesterov == null) continue;
                opBuilder.setAttr("use_nesterov", opts.useNesterov);
            }
        }
        return new ApplyMomentum<T>(opBuilder.build());
    }

    public static Options useLocking(Boolean useLocking) {
        return new Options().useLocking(useLocking);
    }

    public static Options useNesterov(Boolean useNesterov) {
        return new Options().useNesterov(useNesterov);
    }

    public Output<T> out() {
        return this.out;
    }

    @Override
    public Output<T> asOutput() {
        return this.out;
    }

    @OpInputsMetadata(outputsClass=ApplyMomentum.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<ApplyMomentum<T>> {
        public final Operand<T> var;
        public final Operand<T> accum;
        public final Operand<T> lr;
        public final Operand<T> grad;
        public final Operand<T> momentum;
        public final DataType T;
        public final boolean useLocking;
        public final boolean useNesterov;

        public Inputs(GraphOperation op) {
            super(new ApplyMomentum(op), op, Arrays.asList("T", "use_locking", "use_nesterov"));
            int inputIndex = 0;
            this.var = op.input(inputIndex++);
            this.accum = op.input(inputIndex++);
            this.lr = op.input(inputIndex++);
            this.grad = op.input(inputIndex++);
            this.momentum = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.useLocking = op.attributes().getAttrBool("use_locking");
            this.useNesterov = op.attributes().getAttrBool("use_nesterov");
        }
    }

    public static class Options {
        private Boolean useLocking;
        private Boolean useNesterov;

        private Options() {
        }

        public Options useLocking(Boolean useLocking) {
            this.useLocking = useLocking;
            return this;
        }

        public Options useNesterov(Boolean useNesterov) {
            this.useNesterov = useNesterov;
            return this;
        }
    }
}

