/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.train;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ApplyAdam", inputsClass=Inputs.class)
public final class ApplyAdam<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "ApplyAdam";
    private Output<T> out;

    public ApplyAdam(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.out = operation.output(outputIdx++);
    }

    public static <T extends TType> ApplyAdam<T> create(Scope scope, Operand<T> var, Operand<T> m, Operand<T> v, Operand<T> beta1Power, Operand<T> beta2Power, Operand<T> lr, Operand<T> beta1, Operand<T> beta2, Operand<T> epsilon, Operand<T> grad, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(var.asOutput());
        opBuilder.addInput(m.asOutput());
        opBuilder.addInput(v.asOutput());
        opBuilder.addInput(beta1Power.asOutput());
        opBuilder.addInput(beta2Power.asOutput());
        opBuilder.addInput(lr.asOutput());
        opBuilder.addInput(beta1.asOutput());
        opBuilder.addInput(beta2.asOutput());
        opBuilder.addInput(epsilon.asOutput());
        opBuilder.addInput(grad.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.useLocking != null) {
                    opBuilder.setAttr("use_locking", opts.useLocking);
                }
                if (opts.useNesterov == null) continue;
                opBuilder.setAttr("use_nesterov", opts.useNesterov);
            }
        }
        return new ApplyAdam<T>(opBuilder.build());
    }

    public static Options useLocking(Boolean useLocking) {
        return new Options().useLocking(useLocking);
    }

    public static Options useNesterov(Boolean useNesterov) {
        return new Options().useNesterov(useNesterov);
    }

    public Output<T> out() {
        return this.out;
    }

    @Override
    public Output<T> asOutput() {
        return this.out;
    }

    @OpInputsMetadata(outputsClass=ApplyAdam.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<ApplyAdam<T>> {
        public final Operand<T> var;
        public final Operand<T> m;
        public final Operand<T> v;
        public final Operand<T> beta1Power;
        public final Operand<T> beta2Power;
        public final Operand<T> lr;
        public final Operand<T> beta1;
        public final Operand<T> beta2;
        public final Operand<T> epsilon;
        public final Operand<T> grad;
        public final DataType T;
        public final boolean useLocking;
        public final boolean useNesterov;

        public Inputs(GraphOperation op) {
            super(new ApplyAdam(op), op, Arrays.asList("T", "use_locking", "use_nesterov"));
            int inputIndex = 0;
            this.var = op.input(inputIndex++);
            this.m = op.input(inputIndex++);
            this.v = op.input(inputIndex++);
            this.beta1Power = op.input(inputIndex++);
            this.beta2Power = op.input(inputIndex++);
            this.lr = op.input(inputIndex++);
            this.beta1 = op.input(inputIndex++);
            this.beta2 = op.input(inputIndex++);
            this.epsilon = op.input(inputIndex++);
            this.grad = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.useLocking = op.attributes().getAttrBool("use_locking");
            this.useNesterov = op.attributes().getAttrBool("use_nesterov");
        }
    }

    public static class Options {
        private Boolean useLocking;
        private Boolean useNesterov;

        private Options() {
        }

        public Options useLocking(Boolean useLocking) {
            this.useLocking = useLocking;
            return this;
        }

        public Options useNesterov(Boolean useNesterov) {
            this.useNesterov = useNesterov;
            return this;
        }
    }
}

