/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="SparseSegmentMeanGradV2", inputsClass=Inputs.class)
public final class SparseSegmentMeanGrad<T extends TNumber, U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "SparseSegmentMeanGradV2";
    private Output<T> output;
    private Output<U> sortedUniqueIndices;

    public SparseSegmentMeanGrad(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
        this.sortedUniqueIndices = operation.output(outputIdx++);
    }

    public static <T extends TNumber, U extends TNumber> SparseSegmentMeanGrad<T, U> create(Scope scope, Operand<T> grad, Operand<U> indices, Operand<? extends TNumber> segmentIds, Operand<TInt32> denseOutputDim0) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "SparseSegmentMeanGrad");
        opBuilder.addInput(grad.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(segmentIds.asOutput());
        opBuilder.addInput(denseOutputDim0.asOutput());
        return new SparseSegmentMeanGrad<T, U>(opBuilder.build());
    }

    public Output<T> output() {
        return this.output;
    }

    public Output<U> sortedUniqueIndices() {
        return this.sortedUniqueIndices;
    }

    @OpInputsMetadata(outputsClass=SparseSegmentMeanGrad.class)
    public static class Inputs<T extends TNumber, U extends TNumber>
    extends RawOpInputs<SparseSegmentMeanGrad<T, U>> {
        public final Operand<T> grad;
        public final Operand<U> indices;
        public final Operand<? extends TNumber> segmentIds;
        public final Operand<TInt32> denseOutputDim0;
        public final DataType T;
        public final DataType Tidx;
        public final DataType Tsegmentids;

        public Inputs(GraphOperation op) {
            super(new SparseSegmentMeanGrad(op), op, Arrays.asList("T", "Tidx", "Tsegmentids"));
            int inputIndex = 0;
            this.grad = op.input(inputIndex++);
            this.indices = op.input(inputIndex++);
            this.segmentIds = op.input(inputIndex++);
            this.denseOutputDim0 = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tidx = op.attributes().getAttrType("Tidx");
            this.Tsegmentids = op.attributes().getAttrType("Tsegmentids");
        }
    }
}

