/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.random;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="RandomPoissonV2", inputsClass=Inputs.class)
public final class RandomPoisson<V extends TNumber>
extends RawOp
implements Operand<V> {
    public static final String OP_NAME = "RandomPoissonV2";
    private Output<V> output;

    public RandomPoisson(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <V extends TNumber> RandomPoisson<V> create(Scope scope, Operand<? extends TNumber> shape, Operand<? extends TNumber> rate, Class<V> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "RandomPoisson");
        opBuilder.addInput(shape.asOutput());
        opBuilder.addInput(rate.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.seed != null) {
                    opBuilder.setAttr("seed", opts.seed);
                }
                if (opts.seed2 == null) continue;
                opBuilder.setAttr("seed2", opts.seed2);
            }
        }
        return new RandomPoisson<V>(opBuilder.build());
    }

    public static RandomPoisson<TInt64> create(Scope scope, Operand<? extends TNumber> shape, Operand<? extends TNumber> rate, Options[] options) {
        return RandomPoisson.create(scope, shape, rate, TInt64.class, options);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public Output<V> output() {
        return this.output;
    }

    @Override
    public Output<V> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=RandomPoisson.class)
    public static class Inputs
    extends RawOpInputs<RandomPoisson<?>> {
        public final Operand<? extends TNumber> shape;
        public final Operand<? extends TNumber> rate;
        public final long seed;
        public final long seed2;
        public final DataType S;
        public final DataType R;
        public final DataType dtype;

        public Inputs(GraphOperation op) {
            super(new RandomPoisson(op), op, Arrays.asList("seed", "seed2", "S", "R", "dtype"));
            int inputIndex = 0;
            this.shape = op.input(inputIndex++);
            this.rate = op.input(inputIndex++);
            this.seed = op.attributes().getAttrInt("seed");
            this.seed2 = op.attributes().getAttrInt("seed2");
            this.S = op.attributes().getAttrType("S");
            this.R = op.attributes().getAttrType("R");
            this.dtype = op.attributes().getAttrType("dtype");
        }
    }

    public static class Options {
        private Long seed;
        private Long seed2;

        private Options() {
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }
    }
}

