/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.math;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ArgMin", inputsClass=Inputs.class)
public final class ArgMin<V extends TNumber>
extends RawOp
implements Operand<V> {
    public static final String OP_NAME = "ArgMin";
    private Output<V> output;

    public ArgMin(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <V extends TNumber> ArgMin<V> create(Scope scope, Operand<? extends TType> input, Operand<? extends TNumber> dimension, Class<V> outputType) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(dimension.asOutput());
        opBuilder.setAttr("output_type", Operands.toDataType(outputType));
        return new ArgMin<V>(opBuilder.build());
    }

    public static ArgMin<TInt64> create(Scope scope, Operand<? extends TType> input, Operand<? extends TNumber> dimension) {
        return ArgMin.create(scope, input, dimension, TInt64.class);
    }

    public Output<V> output() {
        return this.output;
    }

    @Override
    public Output<V> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=ArgMin.class)
    public static class Inputs
    extends RawOpInputs<ArgMin<?>> {
        public final Operand<? extends TType> input;
        public final Operand<? extends TNumber> dimension;
        public final DataType T;
        public final DataType Tidx;
        public final DataType outputType;

        public Inputs(GraphOperation op) {
            super(new ArgMin(op), op, Arrays.asList("T", "Tidx", "output_type"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.dimension = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.Tidx = op.attributes().getAttrType("Tidx");
            this.outputType = op.attributes().getAttrType("output_type");
        }
    }
}

