/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.debugging;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DebugNumericSummaryV2", inputsClass=Inputs.class)
public final class DebugNumericsSummary<U extends TNumber>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "DebugNumericSummaryV2";
    private Output<U> output;

    public DebugNumericsSummary(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TNumber> DebugNumericsSummary<U> create(Scope scope, Operand<? extends TType> input, Class<U> outputDtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "DebugNumericsSummary");
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("output_dtype", Operands.toDataType(outputDtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.tensorDebugMode != null) {
                    opBuilder.setAttr("tensor_debug_mode", opts.tensorDebugMode);
                }
                if (opts.tensorId == null) continue;
                opBuilder.setAttr("tensor_id", opts.tensorId);
            }
        }
        return new DebugNumericsSummary<U>(opBuilder.build());
    }

    public static DebugNumericsSummary<TFloat32> create(Scope scope, Operand<? extends TType> input, Options[] options) {
        return DebugNumericsSummary.create(scope, input, TFloat32.class, options);
    }

    public static Options tensorDebugMode(Long tensorDebugMode) {
        return new Options().tensorDebugMode(tensorDebugMode);
    }

    public static Options tensorId(Long tensorId) {
        return new Options().tensorId(tensorId);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=DebugNumericsSummary.class)
    public static class Inputs
    extends RawOpInputs<DebugNumericsSummary<?>> {
        public final Operand<? extends TType> input;
        public final DataType outputDtype;
        public final DataType T;
        public final long tensorDebugMode;
        public final long tensorId;

        public Inputs(GraphOperation op) {
            super(new DebugNumericsSummary(op), op, Arrays.asList("output_dtype", "T", "tensor_debug_mode", "tensor_id"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.outputDtype = op.attributes().getAttrType("output_dtype");
            this.T = op.attributes().getAttrType("T");
            this.tensorDebugMode = op.attributes().getAttrInt("tensor_debug_mode");
            this.tensorId = op.attributes().getAttrInt("tensor_id");
        }
    }

    public static class Options {
        private Long tensorDebugMode;
        private Long tensorId;

        private Options() {
        }

        public Options tensorDebugMode(Long tensorDebugMode) {
            this.tensorDebugMode = tensorDebugMode;
            return this;
        }

        public Options tensorId(Long tensorId) {
            this.tensorId = tensorId;
            return this;
        }
    }
}

