/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="DatasetToGraphV2", inputsClass=Inputs.class)
public final class DatasetToGraph
extends RawOp
implements Operand<TString> {
    public static final String OP_NAME = "DatasetToGraphV2";
    private Output<TString> graph;

    public DatasetToGraph(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.graph = operation.output(outputIdx++);
    }

    public static DatasetToGraph create(Scope scope, Operand<? extends TType> inputDataset, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "DatasetToGraph");
        opBuilder.addInput(inputDataset.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.externalStatePolicy != null) {
                    opBuilder.setAttr("external_state_policy", opts.externalStatePolicy);
                }
                if (opts.stripDeviceAssignment == null) continue;
                opBuilder.setAttr("strip_device_assignment", opts.stripDeviceAssignment);
            }
        }
        return new DatasetToGraph(opBuilder.build());
    }

    public static Options externalStatePolicy(Long externalStatePolicy) {
        return new Options().externalStatePolicy(externalStatePolicy);
    }

    public static Options stripDeviceAssignment(Boolean stripDeviceAssignment) {
        return new Options().stripDeviceAssignment(stripDeviceAssignment);
    }

    public Output<TString> graph() {
        return this.graph;
    }

    @Override
    public Output<TString> asOutput() {
        return this.graph;
    }

    @OpInputsMetadata(outputsClass=DatasetToGraph.class)
    public static class Inputs
    extends RawOpInputs<DatasetToGraph> {
        public final Operand<? extends TType> inputDataset;
        public final long externalStatePolicy;
        public final boolean stripDeviceAssignment;

        public Inputs(GraphOperation op) {
            super(new DatasetToGraph(op), op, Arrays.asList("external_state_policy", "strip_device_assignment"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.externalStatePolicy = op.attributes().getAttrInt("external_state_policy");
            this.stripDeviceAssignment = op.attributes().getAttrBool("strip_device_assignment");
        }
    }

    public static class Options {
        private Long externalStatePolicy;
        private Boolean stripDeviceAssignment;

        private Options() {
        }

        public Options externalStatePolicy(Long externalStatePolicy) {
            this.externalStatePolicy = externalStatePolicy;
            return this;
        }

        public Options stripDeviceAssignment(Boolean stripDeviceAssignment) {
            this.stripDeviceAssignment = stripDeviceAssignment;
            return this;
        }
    }
}

