/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorListStack", inputsClass=Inputs.class)
public final class TensorListStack<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "TensorListStack";
    private Output<T> tensor;

    public TensorListStack(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.tensor = operation.output(outputIdx++);
    }

    public static <T extends TType> TensorListStack<T> create(Scope scope, Operand<? extends TType> inputHandle, Operand<TInt32> elementShape, Class<T> elementDtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputHandle.asOutput());
        opBuilder.addInput(elementShape.asOutput());
        opBuilder.setAttr("element_dtype", Operands.toDataType(elementDtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.numElements == null) continue;
                opBuilder.setAttr("num_elements", opts.numElements);
            }
        }
        return new TensorListStack<T>(opBuilder.build());
    }

    public static Options numElements(Long numElements) {
        return new Options().numElements(numElements);
    }

    public Output<T> tensor() {
        return this.tensor;
    }

    @Override
    public Output<T> asOutput() {
        return this.tensor;
    }

    @OpInputsMetadata(outputsClass=TensorListStack.class)
    public static class Inputs
    extends RawOpInputs<TensorListStack<?>> {
        public final Operand<? extends TType> inputHandle;
        public final Operand<TInt32> elementShape;
        public final DataType elementDtype;
        public final long numElements;

        public Inputs(GraphOperation op) {
            super(new TensorListStack(op), op, Arrays.asList("element_dtype", "num_elements"));
            int inputIndex = 0;
            this.inputHandle = op.input(inputIndex++);
            this.elementShape = op.input(inputIndex++);
            this.elementDtype = op.attributes().getAttrType("element_dtype");
            this.numElements = op.attributes().getAttrInt("num_elements");
        }
    }

    public static class Options {
        private Long numElements;

        private Options() {
        }

        public Options numElements(Long numElements) {
            this.numElements = numElements;
            return this;
        }
    }
}

