/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorListElementShape", inputsClass=Inputs.class)
public final class TensorListElementShape<T extends TNumber>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "TensorListElementShape";
    private Output<T> elementShape;

    public TensorListElementShape(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.elementShape = operation.output(outputIdx++);
    }

    public static <T extends TNumber> TensorListElementShape<T> create(Scope scope, Operand<? extends TType> inputHandle, Class<T> shapeType) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputHandle.asOutput());
        opBuilder.setAttr("shape_type", Operands.toDataType(shapeType));
        return new TensorListElementShape<T>(opBuilder.build());
    }

    public Output<T> elementShape() {
        return this.elementShape;
    }

    @Override
    public Output<T> asOutput() {
        return this.elementShape;
    }

    @OpInputsMetadata(outputsClass=TensorListElementShape.class)
    public static class Inputs
    extends RawOpInputs<TensorListElementShape<?>> {
        public final Operand<? extends TType> inputHandle;
        public final DataType shapeType;

        public Inputs(GraphOperation op) {
            super(new TensorListElementShape(op), op, Arrays.asList("shape_type"));
            int inputIndex = 0;
            this.inputHandle = op.input(inputIndex++);
            this.shapeType = op.attributes().getAttrType("shape_type");
        }
    }
}

