/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="PartitionedCall", inputsClass=Inputs.class)
public final class PartitionedCall
extends RawOp
implements Iterable<Operand<TType>> {
    public static final String OP_NAME = "PartitionedCall";
    private List<Output<?>> output;

    public PartitionedCall(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static PartitionedCall create(Scope scope, Iterable<Operand<?>> args, List<Class<? extends TType>> Tout, ConcreteFunction f, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInputList(Operands.asOutputs(args));
        opBuilder.setAttr("Tout", Operands.toDataTypes(Tout));
        opBuilder.setAttr("f", f);
        if (options != null) {
            for (Options opts : options) {
                if (opts.config != null) {
                    opBuilder.setAttr("config", opts.config);
                }
                if (opts.configProto != null) {
                    opBuilder.setAttr("config_proto", opts.configProto);
                }
                if (opts.executorType == null) continue;
                opBuilder.setAttr("executor_type", opts.executorType);
            }
        }
        return new PartitionedCall(opBuilder.build());
    }

    public static Options config(String config) {
        return new Options().config(config);
    }

    public static Options configProto(String configProto) {
        return new Options().configProto(configProto);
    }

    public static Options executorType(String executorType) {
        return new Options().executorType(executorType);
    }

    public List<Output<?>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<TType>> iterator() {
        return this.output.iterator();
    }

    @OpInputsMetadata(outputsClass=PartitionedCall.class)
    public static class Inputs
    extends RawOpInputs<PartitionedCall> {
        public final Iterable<Operand<?>> args;
        public final DataType[] Tin;
        public final DataType[] Tout;
        public final String config;
        public final String configProto;
        public final String executorType;

        public Inputs(GraphOperation op) {
            super(new PartitionedCall(op), op, Arrays.asList("Tin", "Tout", "config", "config_proto", "executor_type"));
            int inputIndex = 0;
            int argsLength = op.inputListLength("args");
            this.args = Arrays.asList((Operand[])op.inputList(inputIndex, argsLength));
            inputIndex += argsLength;
            this.Tin = op.attributes().getAttrTypeList("Tin");
            this.Tout = op.attributes().getAttrTypeList("Tout");
            this.config = op.attributes().getAttrString("config");
            this.configProto = op.attributes().getAttrString("config_proto");
            this.executorType = op.attributes().getAttrString("executor_type");
        }
    }

    public static class Options {
        private String config;
        private String configProto;
        private String executorType;

        private Options() {
        }

        public Options config(String config) {
            this.config = config;
            return this;
        }

        public Options configProto(String configProto) {
            this.configProto = configProto;
            return this;
        }

        public Options executorType(String executorType) {
            this.executorType = executorType;
            return this;
        }
    }
}

