/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.tensorflow.AbstractGradientAdapter;
import org.tensorflow.Graph;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.internal.c_api.TFJ_Scope;
import org.tensorflow.op.CustomGradient;
import org.tensorflow.op.NativeScope;
import org.tensorflow.op.Ops;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;

final class TypedGradientAdapter<T extends RawOpInputs<?>>
extends AbstractGradientAdapter {
    private final CustomGradient<T> gradient;
    private final Class<T> opInputClass;
    private final Constructor<T> ctor;

    TypedGradientAdapter(CustomGradient<T> gradient, Class<T> opInputClass) {
        this.gradient = gradient;
        this.opInputClass = opInputClass;
        this.ctor = this.opInputClass.getDeclaredConstructors()[0];
    }

    @Override
    protected List<Operand<?>> apply(Graph graph, TFJ_Scope scope, GraphOperation operation, List<Output<?>> gradInputs) {
        try {
            RawOpInputs rawOp = (RawOpInputs)this.ctor.newInstance(operation);
            NativeScope nativeScope = new NativeScope(scope, graph, null).withSubScope(((RawOp)rawOp.getOutputs()).op().name());
            return this.gradient.call(new Ops(nativeScope), rawOp, gradInputs);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Could not instantiate Op class " + this.opInputClass, e);
        }
    }
}

