/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.RawTensor;
import org.tensorflow.SparseTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.internal.types.SparseHelpers;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.buffer.IntDataBuffer;
import org.tensorflow.ndarray.impl.dense.IntDenseNdArray;
import org.tensorflow.ndarray.impl.sparse.IntSparseNdArray;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.TInt64;

public final class TInt32Mapper
extends TensorMapper<TInt32> {
    @Override
    protected TInt32 mapDense(RawTensor tensor) {
        IntDataBuffer buffer = TensorBuffers.toInts(TInt32Mapper.nativeHandle(tensor));
        return new DenseTInt32(tensor, buffer);
    }

    @Override
    protected SparseTensor<TInt32> mapSparse(TInt64 indices, TInt32 values, TInt64 denseShape, PointerScope tensorScope) {
        return new SparseTInt32(indices, values, denseShape, tensorScope);
    }

    private static final class SparseTInt32
    extends IntSparseNdArray
    implements TInt32,
    SparseTensor<TInt32> {
        private final TInt64 denseShape;
        private final PointerScope tensorScope;

        public Class<TInt32> type() {
            return TInt32.class;
        }

        @Override
        public DataType dataType() {
            return this.values().dataType();
        }

        @Override
        public long numBytes() {
            return SparseHelpers.numBytes(this);
        }

        @Override
        public void close() {
            this.tensorScope.close();
        }

        @Override
        public boolean isSparse() {
            return true;
        }

        @Override
        public TInt64 indices() {
            return (TInt64)this.getIndices();
        }

        @Override
        public TInt32 values() {
            return (TInt32)this.getValues();
        }

        @Override
        public TInt64 denseShape() {
            return this.denseShape;
        }

        SparseTInt32(TInt64 indices, TInt32 values, TInt64 denseShape, PointerScope tensorScope) {
            super((LongNdArray)indices, values, 0, SparseHelpers.toDimensionalSpace(denseShape));
            this.denseShape = denseShape;
            this.tensorScope = tensorScope.extend();
        }
    }

    private static final class DenseTInt32
    extends IntDenseNdArray
    implements TInt32 {
        final RawTensor rawTensor;

        public Class<TInt32> type() {
            return TInt32.class;
        }

        @Override
        public DataType dataType() {
            return this.asRawTensor().dataType();
        }

        @Override
        public long numBytes() {
            return this.asRawTensor().numBytes();
        }

        @Override
        public void close() {
            this.asRawTensor().close();
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTInt32(RawTensor rawTensor, IntDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

