/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.types;

import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.RawTensor;
import org.tensorflow.SparseTensor;
import org.tensorflow.TensorMapper;
import org.tensorflow.internal.buffer.TensorBuffers;
import org.tensorflow.internal.types.SparseHelpers;
import org.tensorflow.ndarray.LongNdArray;
import org.tensorflow.ndarray.buffer.BooleanDataBuffer;
import org.tensorflow.ndarray.impl.dense.BooleanDenseNdArray;
import org.tensorflow.ndarray.impl.sparse.BooleanSparseNdArray;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;

public final class TBoolMapper
extends TensorMapper<TBool> {
    @Override
    protected TBool mapDense(RawTensor tensor) {
        BooleanDataBuffer buffer = TensorBuffers.toBooleans(TBoolMapper.nativeHandle(tensor));
        return new DenseTBool(tensor, buffer);
    }

    @Override
    protected SparseTensor<TBool> mapSparse(TInt64 indices, TBool values, TInt64 denseShape, PointerScope tensorScope) {
        return new SparseTBool(indices, values, denseShape, tensorScope);
    }

    private static final class SparseTBool
    extends BooleanSparseNdArray
    implements TBool,
    SparseTensor<TBool> {
        private final TInt64 denseShape;
        private final PointerScope tensorScope;

        public Class<TBool> type() {
            return TBool.class;
        }

        @Override
        public DataType dataType() {
            return this.values().dataType();
        }

        @Override
        public long numBytes() {
            return SparseHelpers.numBytes(this);
        }

        @Override
        public void close() {
            this.tensorScope.close();
        }

        @Override
        public boolean isSparse() {
            return true;
        }

        @Override
        public TInt64 indices() {
            return (TInt64)this.getIndices();
        }

        @Override
        public TBool values() {
            return (TBool)this.getValues();
        }

        @Override
        public TInt64 denseShape() {
            return this.denseShape;
        }

        SparseTBool(TInt64 indices, TBool values, TInt64 denseShape, PointerScope tensorScope) {
            super((LongNdArray)indices, values, false, SparseHelpers.toDimensionalSpace(denseShape));
            this.denseShape = denseShape;
            this.tensorScope = tensorScope.extend();
        }
    }

    private static final class DenseTBool
    extends BooleanDenseNdArray
    implements TBool {
        final RawTensor rawTensor;

        public Class<TBool> type() {
            return TBool.class;
        }

        @Override
        public DataType dataType() {
            return this.asRawTensor().dataType();
        }

        @Override
        public long numBytes() {
            return this.asRawTensor().numBytes();
        }

        @Override
        public void close() {
            this.asRawTensor().close();
        }

        @Override
        public RawTensor asRawTensor() {
            return this.rawTensor;
        }

        DenseTBool(RawTensor rawTensor, BooleanDataBuffer buffer) {
            super(buffer, rawTensor.shape());
            this.rawTensor = rawTensor;
        }
    }
}

