/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.Objects;

public final class DeviceSpec {
    private static final String JOB_PREFIX = "/job:";
    private static final String REPLICA_PREFIX = "/replica:";
    private static final String TASK_PREFIX = "/task:";
    private static final String DEVICE_PREFIX = "/device:";
    private final String job;
    private final Integer replica;
    private final Integer task;
    private final Integer deviceIndex;
    private final DeviceType deviceType;

    public String job() {
        return this.job;
    }

    public Integer replica() {
        return this.replica;
    }

    public Integer task() {
        return this.task;
    }

    public Integer deviceIndex() {
        return this.deviceIndex;
    }

    public DeviceType deviceType() {
        return this.deviceType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DeviceSpec) {
            DeviceSpec that = (DeviceSpec)o;
            return Objects.equals(this.job, that.job) && Objects.equals(this.replica, that.replica) && Objects.equals(this.task, that.task) && Objects.equals(this.deviceIndex, that.deviceIndex) && Objects.equals((Object)this.deviceType, (Object)that.deviceType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.job, this.replica, this.task, this.deviceIndex, this.deviceType});
    }

    public String toString() {
        String deviceString = null;
        if (this.deviceType() != null) {
            String deviceSuffix = this.deviceIndex() == null ? "*" : this.deviceIndex().toString();
            deviceString = String.join((CharSequence)":", this.deviceType().toString().toUpperCase(), deviceSuffix);
        }
        return String.join((CharSequence)"", DeviceSpec.EmptyOrWithPrefix(this.job(), JOB_PREFIX), DeviceSpec.EmptyOrWithPrefix(this.replica(), REPLICA_PREFIX), DeviceSpec.EmptyOrWithPrefix(this.task(), TASK_PREFIX), DeviceSpec.EmptyOrWithPrefix(deviceString, DEVICE_PREFIX));
    }

    private DeviceSpec(String job, Integer replica, Integer task, Integer deviceIndex, DeviceType deviceType) {
        this.job = job;
        this.replica = replica;
        this.task = task;
        this.deviceIndex = deviceIndex;
        this.deviceType = deviceType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static String EmptyOrWithPrefix(String s, String prefix) {
        return s == null ? "" : prefix + s;
    }

    private static String EmptyOrWithPrefix(Integer i, String prefix) {
        return i == null ? "" : prefix + i.toString();
    }

    public static class Builder {
        private String job = null;
        private Integer replica = null;
        private Integer task = null;
        private Integer deviceIndex = null;
        private DeviceType deviceType = null;

        private Builder() {
        }

        public Builder job(String job) {
            this.job = job;
            return this;
        }

        public Builder replica(Integer replica) {
            this.replica = replica;
            return this;
        }

        public Builder task(Integer task) {
            this.task = task;
            return this;
        }

        public Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public Builder deviceType(DeviceType deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public DeviceSpec build() {
            return new DeviceSpec(this.job, this.replica, this.task, this.deviceIndex, this.deviceType);
        }
    }

    public static enum DeviceType {
        CPU,
        GPU,
        TPU,
        CUSTOM;

    }
}

