/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.ArrayList;
import java.util.List;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.PointerScope;
import org.tensorflow.Graph;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.internal.c_api.TFJ_GradFuncAdapter;
import org.tensorflow.internal.c_api.TFJ_GraphId;
import org.tensorflow.internal.c_api.TFJ_Scope;
import org.tensorflow.internal.c_api.TF_Operation;
import org.tensorflow.internal.c_api.TF_Output;

public abstract class AbstractGradientAdapter
extends TFJ_GradFuncAdapter {
    protected AbstractGradientAdapter() {
    }

    protected abstract List<Operand<?>> apply(Graph var1, TFJ_Scope var2, GraphOperation var3, List<Output<?>> var4);

    @Override
    public int call(TFJ_GraphId nativeGraphId, TFJ_Scope nativeScope, TF_Operation nativeOperation, TF_Output nativeGradInputs, int nativeGradInputsLength, PointerPointer nativeGradOutputsPtr) {
        try (PointerScope callScope = new PointerScope();){
            Graph graph = Graph.findGraph(nativeGraphId);
            GraphOperation operation = new GraphOperation(graph, nativeOperation);
            List<Output<?>> gradInputs = AbstractGradientAdapter.fromNativeOutputs(graph, nativeGradInputs, nativeGradInputsLength);
            graph.setDangerousGradientBuilder(true);
            List<Operand<?>> gradOutputs = this.apply(graph, nativeScope, operation, gradInputs);
            graph.setDangerousGradientBuilder(false);
            nativeGradOutputsPtr.put((Pointer)AbstractGradientAdapter.toNativeOutputs(gradOutputs));
            int n = gradOutputs.size();
            return n;
        }
    }

    private static List<Output<?>> fromNativeOutputs(Graph g, TF_Output nativeOutputs, int length) {
        ArrayList outputs = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            TF_Output nativeOutput = nativeOutputs.position(i);
            outputs.add(i, new Output(new GraphOperation(g, nativeOutput.oper()), nativeOutput.index()));
        }
        return outputs;
    }

    private static TF_Output toNativeOutputs(List<Operand<?>> outputs) {
        TF_Output nativeOutputs = new TF_Output(Pointer.malloc((long)((long)outputs.size() * (long)Pointer.sizeof(TF_Output.class))));
        for (int i = 0; i < outputs.size(); ++i) {
            Output<?> output = outputs.get(i).asOutput();
            TF_Output nativeOutput = nativeOutputs.getPointer(i);
            nativeOutput.oper(((GraphOperation)output.op()).getUnsafeNativeHandle());
            nativeOutput.index(output.index());
        }
        return nativeOutputs;
    }
}

