/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.tpu;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="OutfeedDequeue", inputsClass=Inputs.class)
public final class OutfeedDequeue<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "OutfeedDequeue";
    private Output<T> output;

    public OutfeedDequeue(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> OutfeedDequeue<T> create(Scope scope, Class<T> dtype, Shape shape, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        opBuilder.setAttr("shape", shape);
        if (options != null) {
            for (Options opts : options) {
                if (opts.deviceOrdinal == null) continue;
                opBuilder.setAttr("device_ordinal", opts.deviceOrdinal);
            }
        }
        return new OutfeedDequeue<T>(opBuilder.build());
    }

    public static Options deviceOrdinal(Long deviceOrdinal) {
        return new Options().deviceOrdinal(deviceOrdinal);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=OutfeedDequeue.class)
    public static class Inputs
    extends RawOpInputs<OutfeedDequeue<?>> {
        public final DataType dtype;
        public final Shape shape;
        public final long deviceOrdinal;

        public Inputs(GraphOperation op) {
            super(new OutfeedDequeue(op), op, Arrays.asList("dtype", "shape", "device_ordinal"));
            boolean inputIndex = false;
            this.dtype = op.attributes().getAttrType("dtype");
            this.shape = op.attributes().getAttrShape("shape");
            this.deviceOrdinal = op.attributes().getAttrInt("device_ordinal");
        }
    }

    public static class Options {
        private Long deviceOrdinal;

        private Options() {
        }

        public Options deviceOrdinal(Long deviceOrdinal) {
            this.deviceOrdinal = deviceOrdinal;
            return this;
        }
    }
}

