/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data.experimental;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="ExperimentalSqlDataset", inputsClass=Inputs.class)
public final class SqlDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "ExperimentalSqlDataset";
    private Output<? extends TType> handle;

    public SqlDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static SqlDataset create(Scope scope, Operand<TString> driverName, Operand<TString> dataSourceName, Operand<TString> query, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "SqlDataset");
        opBuilder.addInput(driverName.asOutput());
        opBuilder.addInput(dataSourceName.asOutput());
        opBuilder.addInput(query.asOutput());
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        return new SqlDataset(opBuilder.build());
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=SqlDataset.class)
    public static class Inputs
    extends RawOpInputs<SqlDataset> {
        public final Operand<TString> driverName;
        public final Operand<TString> dataSourceName;
        public final Operand<TString> query;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;

        public Inputs(GraphOperation op) {
            super(new SqlDataset(op), op, Arrays.asList("output_types", "output_shapes"));
            int inputIndex = 0;
            this.driverName = op.input(inputIndex++);
            this.dataSourceName = op.input(inputIndex++);
            this.query = op.input(inputIndex++);
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
        }
    }
}

