/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.tensorflow.DeviceSpec;
import org.tensorflow.ExecutionEnvironment;
import org.tensorflow.Graph;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.internal.c_api.TFJ_Scope;
import org.tensorflow.internal.c_api.TF_Operation;
import org.tensorflow.internal.c_api.global.tensorflow;
import org.tensorflow.op.Op;
import org.tensorflow.op.Scope;

public final class NativeScope
implements Scope {
    private final Graph graph;
    private final TFJ_Scope nativeScope;
    private final String opName;
    private final String device;

    @Override
    public ExecutionEnvironment env() {
        return this.graph;
    }

    @Override
    public NativeScope withSubScope(String childScopeName) {
        return new NativeScope(tensorflow.TFJ_NewSubScope(this.nativeScope, childScopeName), this.graph, null, this.device);
    }

    @Override
    public NativeScope withName(String opName) {
        return new NativeScope(this.nativeScope, this.graph, opName, this.device);
    }

    @Override
    public NativeScope withNameAsSubScope(String defaultName) {
        if (this.opName == null) {
            return this.withSubScope(defaultName);
        }
        return this.withSubScope(this.opName);
    }

    @Override
    public NativeScope withDevice(DeviceSpec newDevice) {
        return new NativeScope(tensorflow.TFJ_NewScopeWithDevice(this.nativeScope, newDevice.toString()), this.graph, newDevice.toString());
    }

    @Override
    public Scope withInitScope() {
        throw new IllegalStateException("Can't add init operations in a native scope");
    }

    @Override
    public String makeOpName(String defaultName) {
        String name = this.opName != null ? this.opName : defaultName;
        return tensorflow.TFJ_GetUniqueNameForOp(this.nativeScope, name);
    }

    @Override
    public String makeUnique(String id) {
        return tensorflow.TFJ_GetUniqueNameForOp(this.nativeScope, id);
    }

    @Override
    public void refreshNames() {
    }

    @Override
    public Scope withControlDependencies(Iterable<Op> controls) {
        return this.withControlDependencyOps(StreamSupport.stream(controls.spliterator(), false).map(Op::op).collect(Collectors.toList()));
    }

    @Override
    public Scope withControlDependencyOps(Iterable<Operation> controls) {
        List controlDeps = StreamSupport.stream(controls.spliterator(), false).collect(Collectors.toList());
        TF_Operation[] ops = new TF_Operation[controlDeps.size()];
        for (int i = 0; i < controlDeps.size(); ++i) {
            Operation op = (Operation)controlDeps.get(i);
            if (!(op instanceof GraphOperation)) {
                throw new IllegalArgumentException("Can only add graph ops as control dependencies");
            }
            ops[i] = ((GraphOperation)op).getUnsafeNativeHandle();
        }
        return new NativeScope(tensorflow.TFJ_NewScopeWithControlDependencies(this.nativeScope, ops[0], ops.length), this.graph, this.device);
    }

    @Override
    public OperationBuilder apply(OperationBuilder builder) {
        return builder;
    }

    @Override
    public String getDeviceString() {
        if (this.device == null) {
            throw new UnsupportedOperationException("Can't get device string for native scope unless it has been explicitly set");
        }
        return this.device;
    }

    @Override
    public boolean isInit() {
        return false;
    }

    NativeScope(TFJ_Scope nativeScope, Graph graph, String device) {
        this(nativeScope, graph, null, device);
    }

    private NativeScope(TFJ_Scope nativeScope, Graph graph, String opName, String device) {
        this.graph = graph;
        this.nativeScope = nativeScope;
        this.opName = opName;
        this.device = device;
    }
}

