/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="GRUBlockCell", inputsClass=Inputs.class)
public final class GRUBlockCell<T extends TNumber>
extends RawOp {
    public static final String OP_NAME = "GRUBlockCell";
    private Output<T> r;
    private Output<T> u;
    private Output<T> c;
    private Output<T> h;

    public GRUBlockCell(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.r = operation.output(outputIdx++);
        this.u = operation.output(outputIdx++);
        this.c = operation.output(outputIdx++);
        this.h = operation.output(outputIdx++);
    }

    public static <T extends TNumber> GRUBlockCell<T> create(Scope scope, Operand<T> x, Operand<T> hPrev, Operand<T> wRu, Operand<T> wC, Operand<T> bRu, Operand<T> bC) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(x.asOutput());
        opBuilder.addInput(hPrev.asOutput());
        opBuilder.addInput(wRu.asOutput());
        opBuilder.addInput(wC.asOutput());
        opBuilder.addInput(bRu.asOutput());
        opBuilder.addInput(bC.asOutput());
        return new GRUBlockCell<T>(opBuilder.build());
    }

    public Output<T> r() {
        return this.r;
    }

    public Output<T> u() {
        return this.u;
    }

    public Output<T> c() {
        return this.c;
    }

    public Output<T> h() {
        return this.h;
    }

    @OpInputsMetadata(outputsClass=GRUBlockCell.class)
    public static class Inputs<T extends TNumber>
    extends RawOpInputs<GRUBlockCell<T>> {
        public final Operand<T> x;
        public final Operand<T> hPrev;
        public final Operand<T> wRu;
        public final Operand<T> wC;
        public final Operand<T> bRu;
        public final Operand<T> bC;
        public final DataType T;

        public Inputs(GraphOperation op) {
            super(new GRUBlockCell(op), op, Arrays.asList("T"));
            int inputIndex = 0;
            this.x = op.input(inputIndex++);
            this.hPrev = op.input(inputIndex++);
            this.wRu = op.input(inputIndex++);
            this.wC = op.input(inputIndex++);
            this.bRu = op.input(inputIndex++);
            this.bC = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
        }
    }
}

