/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TBool;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="RebatchDatasetV2", inputsClass=Inputs.class)
public final class RebatchDatasetV2
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "RebatchDatasetV2";
    private Output<? extends TType> handle;

    public RebatchDatasetV2(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static RebatchDatasetV2 create(Scope scope, Operand<? extends TType> inputDataset, Operand<TInt64> batchSizes, Operand<TBool> dropRemainder, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(inputDataset.asOutput());
        opBuilder.addInput(batchSizes.asOutput());
        opBuilder.addInput(dropRemainder.asOutput());
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        return new RebatchDatasetV2(opBuilder.build());
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=RebatchDatasetV2.class)
    public static class Inputs
    extends RawOpInputs<RebatchDatasetV2> {
        public final Operand<? extends TType> inputDataset;
        public final Operand<TInt64> batchSizes;
        public final Operand<TBool> dropRemainder;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;

        public Inputs(GraphOperation op) {
            super(new RebatchDatasetV2(op), op, Arrays.asList("output_types", "output_shapes"));
            int inputIndex = 0;
            this.inputDataset = op.input(inputIndex++);
            this.batchSizes = op.input(inputIndex++);
            this.dropRemainder = op.input(inputIndex++);
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
        }
    }
}

