/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.data;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.ConcreteFunction;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TString;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="LoadDataset", inputsClass=Inputs.class)
public final class LoadDataset
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "LoadDataset";
    private Output<? extends TType> handle;

    public LoadDataset(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
    }

    public static LoadDataset create(Scope scope, Operand<TString> path, Iterable<Operand<?>> readerFuncOtherArgs, List<Class<? extends TType>> outputTypes, List<Shape> outputShapes, ConcreteFunction readerFunc, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(path.asOutput());
        opBuilder.addInputList(Operands.asOutputs(readerFuncOtherArgs));
        opBuilder.setAttr("output_types", Operands.toDataTypes(outputTypes));
        Shape[] outputShapesArray = new Shape[outputShapes.size()];
        for (int i = 0; i < outputShapesArray.length; ++i) {
            outputShapesArray[i] = outputShapes.get(i);
        }
        opBuilder.setAttr("output_shapes", outputShapesArray);
        opBuilder.setAttr("reader_func", readerFunc);
        if (options != null) {
            for (Options opts : options) {
                if (opts.compression == null) continue;
                opBuilder.setAttr("compression", opts.compression);
            }
        }
        return new LoadDataset(opBuilder.build());
    }

    public static Options compression(String compression) {
        return new Options().compression(compression);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.handle;
    }

    @OpInputsMetadata(outputsClass=LoadDataset.class)
    public static class Inputs
    extends RawOpInputs<LoadDataset> {
        public final Operand<TString> path;
        public final Iterable<Operand<?>> readerFuncOtherArgs;
        public final DataType[] outputTypes;
        public final Shape[] outputShapes;
        public final String compression;
        public final DataType[] TreaderFuncArgs;

        public Inputs(GraphOperation op) {
            super(new LoadDataset(op), op, Arrays.asList("output_types", "output_shapes", "compression", "Treader_func_args"));
            int inputIndex = 0;
            this.path = op.input(inputIndex++);
            int readerFuncOtherArgsLength = op.inputListLength("reader_func_other_args");
            this.readerFuncOtherArgs = Arrays.asList((Operand[])op.inputList(inputIndex, readerFuncOtherArgsLength));
            inputIndex += readerFuncOtherArgsLength;
            this.outputTypes = op.attributes().getAttrTypeList("output_types");
            this.outputShapes = op.attributes().getAttrShapeList("output_shapes");
            this.compression = op.attributes().getAttrString("compression");
            this.TreaderFuncArgs = op.attributes().getAttrTypeList("Treader_func_args");
        }
    }

    public static class Options {
        private String compression;

        private Options() {
        }

        public Options compression(String compression) {
            this.compression = compression;
            return this;
        }
    }
}

