/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorListScatterV2", inputsClass=Inputs.class)
public final class TensorListScatter
extends RawOp
implements Operand<TType> {
    public static final String OP_NAME = "TensorListScatterV2";
    private Output<? extends TType> outputHandle;

    public TensorListScatter(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputHandle = operation.output(outputIdx++);
    }

    public static TensorListScatter create(Scope scope, Operand<? extends TType> tensor, Operand<TInt32> indices, Operand<? extends TNumber> elementShape, Operand<TInt32> numElements) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "TensorListScatter");
        opBuilder.addInput(tensor.asOutput());
        opBuilder.addInput(indices.asOutput());
        opBuilder.addInput(elementShape.asOutput());
        opBuilder.addInput(numElements.asOutput());
        return new TensorListScatter(opBuilder.build());
    }

    public Output<? extends TType> outputHandle() {
        return this.outputHandle;
    }

    @Override
    public Output<TType> asOutput() {
        return this.outputHandle;
    }

    @OpInputsMetadata(outputsClass=TensorListScatter.class)
    public static class Inputs
    extends RawOpInputs<TensorListScatter> {
        public final Operand<? extends TType> tensor;
        public final Operand<TInt32> indices;
        public final Operand<? extends TNumber> elementShape;
        public final Operand<TInt32> numElements;
        public final DataType elementDtype;
        public final DataType shapeType;

        public Inputs(GraphOperation op) {
            super(new TensorListScatter(op), op, Arrays.asList("element_dtype", "shape_type"));
            int inputIndex = 0;
            this.tensor = op.input(inputIndex++);
            this.indices = op.input(inputIndex++);
            this.elementShape = op.input(inputIndex++);
            this.numElements = op.input(inputIndex++);
            this.elementDtype = op.attributes().getAttrType("element_dtype");
            this.shapeType = op.attributes().getAttrType("shape_type");
        }
    }
}

