/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="TensorArrayV3", inputsClass=Inputs.class)
public final class TensorArray
extends RawOp {
    public static final String OP_NAME = "TensorArrayV3";
    private Output<? extends TType> handle;
    private Output<TFloat32> flow;

    public TensorArray(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.handle = operation.output(outputIdx++);
        this.flow = operation.output(outputIdx++);
    }

    public static <T extends TType> TensorArray create(Scope scope, Operand<TInt32> sizeOutput, Class<T> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, "TensorArray");
        opBuilder.addInput(sizeOutput.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.elementShape != null) {
                    opBuilder.setAttr("element_shape", opts.elementShape);
                }
                if (opts.dynamicSize != null) {
                    opBuilder.setAttr("dynamic_size", opts.dynamicSize);
                }
                if (opts.clearAfterRead != null) {
                    opBuilder.setAttr("clear_after_read", opts.clearAfterRead);
                }
                if (opts.identicalElementShapes != null) {
                    opBuilder.setAttr("identical_element_shapes", opts.identicalElementShapes);
                }
                if (opts.tensorArrayName == null) continue;
                opBuilder.setAttr("tensor_array_name", opts.tensorArrayName);
            }
        }
        return new TensorArray(opBuilder.build());
    }

    public static Options elementShape(Shape elementShape) {
        return new Options().elementShape(elementShape);
    }

    public static Options dynamicSize(Boolean dynamicSize) {
        return new Options().dynamicSize(dynamicSize);
    }

    public static Options clearAfterRead(Boolean clearAfterRead) {
        return new Options().clearAfterRead(clearAfterRead);
    }

    public static Options identicalElementShapes(Boolean identicalElementShapes) {
        return new Options().identicalElementShapes(identicalElementShapes);
    }

    public static Options tensorArrayName(String tensorArrayName) {
        return new Options().tensorArrayName(tensorArrayName);
    }

    public Output<? extends TType> handle() {
        return this.handle;
    }

    public Output<TFloat32> flow() {
        return this.flow;
    }

    @OpInputsMetadata(outputsClass=TensorArray.class)
    public static class Inputs
    extends RawOpInputs<TensorArray> {
        public final Operand<TInt32> sizeOutput;
        public final DataType dtype;
        public final Shape elementShape;
        public final boolean dynamicSize;
        public final boolean clearAfterRead;
        public final boolean identicalElementShapes;
        public final String tensorArrayName;

        public Inputs(GraphOperation op) {
            super(new TensorArray(op), op, Arrays.asList("dtype", "element_shape", "dynamic_size", "clear_after_read", "identical_element_shapes", "tensor_array_name"));
            int inputIndex = 0;
            this.sizeOutput = op.input(inputIndex++);
            this.dtype = op.attributes().getAttrType("dtype");
            this.elementShape = op.attributes().getAttrShape("element_shape");
            this.dynamicSize = op.attributes().getAttrBool("dynamic_size");
            this.clearAfterRead = op.attributes().getAttrBool("clear_after_read");
            this.identicalElementShapes = op.attributes().getAttrBool("identical_element_shapes");
            this.tensorArrayName = op.attributes().getAttrString("tensor_array_name");
        }
    }

    public static class Options {
        private Shape elementShape;
        private Boolean dynamicSize;
        private Boolean clearAfterRead;
        private Boolean identicalElementShapes;
        private String tensorArrayName;

        private Options() {
        }

        public Options elementShape(Shape elementShape) {
            this.elementShape = elementShape;
            return this;
        }

        public Options dynamicSize(Boolean dynamicSize) {
            this.dynamicSize = dynamicSize;
            return this;
        }

        public Options clearAfterRead(Boolean clearAfterRead) {
            this.clearAfterRead = clearAfterRead;
            return this;
        }

        public Options identicalElementShapes(Boolean identicalElementShapes) {
            this.identicalElementShapes = identicalElementShapes;
            return this;
        }

        public Options tensorArrayName(String tensorArrayName) {
            this.tensorArrayName = tensorArrayName;
            return this;
        }
    }
}

