/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.tensorflow.Operand;
import org.tensorflow.Output;
import org.tensorflow.ndarray.Shape;
import org.tensorflow.proto.DataType;
import org.tensorflow.proto.SignatureDef;
import org.tensorflow.proto.TensorInfo;
import org.tensorflow.proto.TensorShapeProto;

public class Signature {
    public static final String DEFAULT_KEY = "serving_default";
    private final String key;
    private final SignatureDef signatureDef;
    private Map<String, TensorDescription> inputMap;
    private Map<String, TensorDescription> outputMap;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name) {
        return new Builder().methodName(name).key(name);
    }

    public String key() {
        return this.key;
    }

    public String methodName() {
        return this.signatureDef.getMethodName().isEmpty() ? null : this.signatureDef.getMethodName();
    }

    public Set<String> inputNames() {
        return this.signatureDef.getInputsMap().keySet();
    }

    public Set<String> outputNames() {
        return this.signatureDef.getOutputsMap().keySet();
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder("Signature for \"" + this.key + "\":\n");
        String methodName = this.methodName();
        if (methodName != null && !methodName.isEmpty()) {
            strBuilder.append("\tMethod: \"").append(methodName).append("\"\n");
        }
        if (this.signatureDef.getInputsCount() > 0) {
            strBuilder.append("\tInputs:\n");
            Signature.printTensorInfo(this.signatureDef.getInputsMap(), strBuilder);
        }
        if (this.signatureDef.getOutputsCount() > 0) {
            strBuilder.append("\tOutputs:\n");
            Signature.printTensorInfo(this.signatureDef.getOutputsMap(), strBuilder);
        }
        return strBuilder.toString();
    }

    private Map<String, TensorDescription> buildTensorDescriptionMap(Map<String, TensorInfo> dataMapIn) {
        LinkedHashMap dataTypeMap = new LinkedHashMap();
        dataMapIn.forEach((name, info) -> {
            long[] tensorDims = info.getTensorShape().getDimList().stream().mapToLong(d -> d.getSize()).toArray();
            Shape tensorShape = Shape.of(tensorDims);
            dataTypeMap.put(name, new TensorDescription(info.getDtype(), tensorShape, info.getName()));
        });
        return Collections.unmodifiableMap(dataTypeMap);
    }

    public Map<String, TensorDescription> getInputs() {
        if (this.inputMap == null) {
            this.inputMap = this.buildTensorDescriptionMap(this.signatureDef.getInputsMap());
        }
        return this.inputMap;
    }

    public Map<String, TensorDescription> getOutputs() {
        if (this.outputMap == null) {
            this.outputMap = this.buildTensorDescriptionMap(this.signatureDef.getOutputsMap());
        }
        return this.outputMap;
    }

    Signature(String key, SignatureDef signatureDef) {
        this.key = key;
        this.signatureDef = signatureDef;
    }

    SignatureDef asSignatureDef() {
        return this.signatureDef;
    }

    private static void printTensorInfo(Map<String, TensorInfo> tensorMap, StringBuilder strBuilder) {
        tensorMap.forEach((key, tensorInfo) -> {
            strBuilder.append("\t\t\"").append((String)key).append("\": dtype=").append(tensorInfo.getDtype().name()).append(", shape=(");
            for (int i = 0; i < tensorInfo.getTensorShape().getDimCount(); ++i) {
                strBuilder.append(tensorInfo.getTensorShape().getDim(i).getSize());
                if (i >= tensorInfo.getTensorShape().getDimCount() - 1) continue;
                strBuilder.append(", ");
            }
            strBuilder.append(")\n");
        });
    }

    public static class Builder {
        private String key = "serving_default";
        private final SignatureDef.Builder signatureBuilder = SignatureDef.newBuilder();

        public Builder key(String key) {
            if (key == null || key.isEmpty()) {
                throw new IllegalArgumentException("Invalid key: " + key);
            }
            this.key = key;
            return this;
        }

        public Builder input(String inputName, Operand<?> input) {
            if (this.signatureBuilder.containsInputs(inputName)) {
                throw new IllegalArgumentException("\"" + inputName + "\" is already being mapped to another input");
            }
            this.signatureBuilder.putInputs(inputName, Builder.toTensorInfo(input.asOutput()));
            return this;
        }

        Builder input(String inputName, TensorInfo input) {
            if (this.signatureBuilder.containsInputs(inputName)) {
                throw new IllegalArgumentException("\"" + inputName + "\" is already being mapped to another input");
            }
            this.signatureBuilder.putInputs(inputName, input);
            return this;
        }

        public Builder output(String outputName, Operand<?> output) {
            if (this.signatureBuilder.containsOutputs(outputName)) {
                throw new IllegalArgumentException("\"" + outputName + "\" is already being mapped to another output");
            }
            this.signatureBuilder.putOutputs(outputName, Builder.toTensorInfo(output.asOutput()));
            return this;
        }

        Builder output(String outputName, TensorInfo output) {
            if (this.signatureBuilder.containsOutputs(outputName)) {
                throw new IllegalArgumentException("\"" + outputName + "\" is already being mapped to another output");
            }
            this.signatureBuilder.putOutputs(outputName, output);
            return this;
        }

        public Builder methodName(String methodName) {
            this.signatureBuilder.setMethodName(methodName == null ? "" : methodName);
            return this;
        }

        public Signature build() {
            return new Signature(this.key, this.signatureBuilder.build());
        }

        private static TensorInfo toTensorInfo(Output<?> operand) {
            Shape shape = operand.shape();
            TensorShapeProto.Builder tensorShapeBuilder = TensorShapeProto.newBuilder();
            for (int i = 0; i < shape.numDimensions(); ++i) {
                tensorShapeBuilder.addDim(TensorShapeProto.Dim.newBuilder().setSize(shape.size(i)));
            }
            return TensorInfo.newBuilder().setDtype(operand.dataType()).setTensorShape(tensorShapeBuilder).setName(operand.op().name() + ":" + operand.index()).build();
        }
    }

    public static class TensorDescription {
        public final String name;
        public final DataType dataType;
        public final Shape shape;

        public TensorDescription(DataType dataType, Shape shape, String name) {
            this.dataType = dataType;
            this.shape = shape;
            this.name = name;
        }
    }
}

