/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="UniformQuantizedDotHybrid", inputsClass=Inputs.class)
public final class UniformQuantizedDotHybrid<V extends TNumber>
extends RawOp
implements Operand<V> {
    public static final String OP_NAME = "UniformQuantizedDotHybrid";
    private Output<V> output;

    public UniformQuantizedDotHybrid(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <V extends TNumber> UniformQuantizedDotHybrid<V> create(Scope scope, Operand<? extends TNumber> lhs, Operand<? extends TNumber> rhs, Operand<TFloat32> rhsScales, Operand<TInt32> rhsZeroPoints, Class<V> Tout, Long rhsQuantizationMinVal, Long rhsQuantizationMaxVal, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(lhs.asOutput());
        opBuilder.addInput(rhs.asOutput());
        opBuilder.addInput(rhsScales.asOutput());
        opBuilder.addInput(rhsZeroPoints.asOutput());
        opBuilder.setAttr("Tout", Operands.toDataType(Tout));
        opBuilder.setAttr("rhs_quantization_min_val", rhsQuantizationMinVal);
        opBuilder.setAttr("rhs_quantization_max_val", rhsQuantizationMaxVal);
        if (options != null) {
            for (Options opts : options) {
                if (opts.rhsQuantizationAxis == null) continue;
                opBuilder.setAttr("rhs_quantization_axis", opts.rhsQuantizationAxis);
            }
        }
        return new UniformQuantizedDotHybrid<V>(opBuilder.build());
    }

    public static Options rhsQuantizationAxis(Long rhsQuantizationAxis) {
        return new Options().rhsQuantizationAxis(rhsQuantizationAxis);
    }

    public Output<V> output() {
        return this.output;
    }

    @Override
    public Output<V> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=UniformQuantizedDotHybrid.class)
    public static class Inputs
    extends RawOpInputs<UniformQuantizedDotHybrid<?>> {
        public final Operand<? extends TNumber> lhs;
        public final Operand<? extends TNumber> rhs;
        public final Operand<TFloat32> rhsScales;
        public final Operand<TInt32> rhsZeroPoints;
        public final DataType Tlhs;
        public final DataType Trhs;
        public final DataType Tout;
        public final long rhsQuantizationAxis;
        public final long rhsQuantizationMinVal;
        public final long rhsQuantizationMaxVal;

        public Inputs(GraphOperation op) {
            super(new UniformQuantizedDotHybrid(op), op, Arrays.asList("Tlhs", "Trhs", "Tout", "rhs_quantization_axis", "rhs_quantization_min_val", "rhs_quantization_max_val"));
            int inputIndex = 0;
            this.lhs = op.input(inputIndex++);
            this.rhs = op.input(inputIndex++);
            this.rhsScales = op.input(inputIndex++);
            this.rhsZeroPoints = op.input(inputIndex++);
            this.Tlhs = op.attributes().getAttrType("Tlhs");
            this.Trhs = op.attributes().getAttrType("Trhs");
            this.Tout = op.attributes().getAttrType("Tout");
            this.rhsQuantizationAxis = op.attributes().getAttrInt("rhs_quantization_axis");
            this.rhsQuantizationMinVal = op.attributes().getAttrInt("rhs_quantization_min_val");
            this.rhsQuantizationMaxVal = op.attributes().getAttrInt("rhs_quantization_max_val");
        }
    }

    public static class Options {
        private Long rhsQuantizationAxis;

        private Options() {
        }

        public Options rhsQuantizationAxis(Long rhsQuantizationAxis) {
            this.rhsQuantizationAxis = rhsQuantizationAxis;
            return this;
        }
    }
}

