/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.c_api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Loader;
import org.tensorflow.internal.c_api.global.tensorflow;

public final class TFJ_RuntimeLibrary {
    private static final boolean DEBUG = System.getProperty("org.tensorflow.NativeLibrary.DEBUG") != null;
    private static final String JNI_LIBNAME = "tensorflow_jni";

    public static void load() {
        Loader.load(tensorflow.class);
        if (TFJ_RuntimeLibrary.isLoaded() || TFJ_RuntimeLibrary.tryLoadLibrary()) {
            return;
        }
        String jniLibName = System.mapLibraryName(JNI_LIBNAME);
        String jniResourceName = TFJ_RuntimeLibrary.makeResourceName(jniLibName);
        TFJ_RuntimeLibrary.log("jniResourceName: " + jniResourceName);
        InputStream jniResource = TFJ_RuntimeLibrary.class.getClassLoader().getResourceAsStream(jniResourceName);
        String frameworkLibName = TFJ_RuntimeLibrary.getVersionedLibraryName(System.mapLibraryName("tensorflow_framework"));
        String frameworkResourceName = TFJ_RuntimeLibrary.makeResourceName(frameworkLibName);
        TFJ_RuntimeLibrary.log("frameworkResourceName: " + frameworkResourceName);
        InputStream frameworkResource = TFJ_RuntimeLibrary.class.getClassLoader().getResourceAsStream(frameworkResourceName);
        if (jniResource == null) {
            throw new UnsatisfiedLinkError(String.format("Cannot find TensorFlow native library for OS: %s, architecture: %s. See https://github.com/tensorflow/tensorflow/tree/master/tensorflow/java/README.md for possible solutions (such as building the library from source). Additional information on attempts to find the native library can be obtained by adding org.tensorflow.NativeLibrary.DEBUG=1 to the system properties of the JVM.", TFJ_RuntimeLibrary.os(), TFJ_RuntimeLibrary.architecture()));
        }
        try {
            File tempPath = TFJ_RuntimeLibrary.createTemporaryDirectory();
            tempPath.deleteOnExit();
            String tempDirectory = tempPath.getCanonicalPath();
            if (frameworkResource != null) {
                TFJ_RuntimeLibrary.extractResource(frameworkResource, frameworkLibName, tempDirectory);
            } else {
                TFJ_RuntimeLibrary.log(frameworkResourceName + " not found. This is fine assuming " + jniResourceName + " is not built to depend on it.");
            }
            System.load(TFJ_RuntimeLibrary.extractResource(jniResource, jniLibName, tempDirectory));
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError(String.format("Unable to extract native library into a temporary file (%s)", e.toString()));
        }
    }

    private static boolean tryLoadLibrary() {
        try {
            System.loadLibrary(JNI_LIBNAME);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            TFJ_RuntimeLibrary.log("tryLoadLibraryFailed: " + e.getMessage());
            return false;
        }
    }

    private static boolean isLoaded() {
        boolean bl;
        block8: {
            BytePointer version = tensorflow.TF_Version();
            try {
                TFJ_RuntimeLibrary.log("Version loaded: " + version.toString());
                bl = true;
                if (version == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (version != null) {
                        try {
                            version.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnsatisfiedLinkError e) {
                    return false;
                }
            }
            version.close();
        }
        return bl;
    }

    private static boolean resourceExists(String baseName) {
        return TFJ_RuntimeLibrary.class.getClassLoader().getResource(TFJ_RuntimeLibrary.makeResourceName(baseName)) != null;
    }

    private static String getVersionedLibraryName(String libFilename) {
        if (TFJ_RuntimeLibrary.resourceExists(libFilename)) {
            return libFilename;
        }
        String versionName = TFJ_RuntimeLibrary.getMajorVersionNumber();
        String darwinSuffix = ".dylib";
        if (libFilename.endsWith(".dylib")) {
            String prefix = libFilename.substring(0, libFilename.length() - ".dylib".length());
            if (versionName != null) {
                String darwinVersionedLibrary = prefix + "." + versionName + ".dylib";
                if (TFJ_RuntimeLibrary.resourceExists(darwinVersionedLibrary)) {
                    return darwinVersionedLibrary;
                }
            } else {
                String darwinSoName = prefix + ".so";
                if (TFJ_RuntimeLibrary.resourceExists(darwinSoName)) {
                    return darwinSoName;
                }
            }
        } else if (libFilename.endsWith(".so")) {
            String versionedSoName = libFilename + "." + versionName;
            if (versionName != null && TFJ_RuntimeLibrary.resourceExists(versionedSoName)) {
                return versionedSoName;
            }
        }
        return libFilename;
    }

    private static String getMajorVersionNumber() {
        int dotIndex;
        String version = TFJ_RuntimeLibrary.class.getPackage().getImplementationVersion();
        if (version == null || (dotIndex = version.indexOf(46)) == -1) {
            return null;
        }
        String majorVersion = version.substring(0, dotIndex);
        try {
            Integer.parseInt(majorVersion);
            return majorVersion;
        }
        catch (NumberFormatException unused) {
            return null;
        }
    }

    private static String extractResource(InputStream resource, String resourceName, String extractToDirectory) throws IOException {
        File dst = new File(extractToDirectory, resourceName);
        dst.deleteOnExit();
        String dstPath = dst.toString();
        TFJ_RuntimeLibrary.log("extracting native library to: " + dstPath);
        long nbytes = TFJ_RuntimeLibrary.copy(resource, dst);
        TFJ_RuntimeLibrary.log(String.format("copied %d bytes to %s", nbytes, dstPath));
        return dstPath;
    }

    private static String os() {
        String p = System.getProperty("os.name").toLowerCase();
        if (p.contains("linux")) {
            return "linux";
        }
        if (p.contains("os x") || p.contains("darwin")) {
            return "darwin";
        }
        if (p.contains("windows")) {
            return "windows";
        }
        return p.replaceAll("\\s", "");
    }

    private static String architecture() {
        String arch = System.getProperty("os.arch").toLowerCase();
        return arch.equals("amd64") ? "x86_64" : arch;
    }

    private static void log(String msg) {
        if (DEBUG) {
            System.err.println("org.tensorflow.NativeLibrary: " + msg);
        }
    }

    private static String makeResourceName(String baseName) {
        return "org/tensorflow/native/" + String.format("%s-%s/", TFJ_RuntimeLibrary.os(), TFJ_RuntimeLibrary.architecture()) + baseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copy(InputStream src, File dstFile) throws IOException {
        FileOutputStream dst = new FileOutputStream(dstFile);
        try {
            byte[] buffer = new byte[0x100000];
            long ret = 0L;
            int n = 0;
            while ((n = src.read(buffer)) >= 0) {
                dst.write(buffer, 0, n);
                ret += (long)n;
            }
            long l = ret;
            return l;
        }
        finally {
            dst.close();
            src.close();
        }
    }

    private static File createTemporaryDirectory() {
        File baseDirectory = new File(System.getProperty("java.io.tmpdir"));
        String directoryName = "tensorflow_native_libraries-" + System.currentTimeMillis() + "-";
        for (int attempt = 0; attempt < 1000; ++attempt) {
            File temporaryDirectory = new File(baseDirectory, directoryName + attempt);
            if (!temporaryDirectory.mkdir()) continue;
            return temporaryDirectory;
        }
        throw new IllegalStateException("Could not create a temporary directory (tried to make " + directoryName + "*) to extract TensorFlow native libraries.");
    }

    private TFJ_RuntimeLibrary() {
    }
}

