/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.xla;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.TInt32;

@OpMetadata(opType="XlaSparseDenseMatmulGradWithSgdAndCsrInput", inputsClass=Inputs.class)
public final class XlaSparseDenseMatmulGradWithSgdAndCsrInput
extends RawOp
implements Operand<TFloat32> {
    public static final String OP_NAME = "XlaSparseDenseMatmulGradWithSgdAndCsrInput";
    private Output<TFloat32> updatedEmbeddingTable;

    public XlaSparseDenseMatmulGradWithSgdAndCsrInput(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.updatedEmbeddingTable = operation.output(outputIdx++);
    }

    public static XlaSparseDenseMatmulGradWithSgdAndCsrInput create(Scope scope, Operand<TInt32> rowPointers, Operand<TInt32> sortedSampleIds, Operand<TInt32> sortedTokenIds, Operand<TFloat32> sortedGains, Operand<TFloat32> activationGradients, Operand<TFloat32> learningRate, Operand<TFloat32> embeddingTable, Operand<TInt32> numMinibatchesPerPhysicalSparseCore, String tableName, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(rowPointers.asOutput());
        opBuilder.addInput(sortedSampleIds.asOutput());
        opBuilder.addInput(sortedTokenIds.asOutput());
        opBuilder.addInput(sortedGains.asOutput());
        opBuilder.addInput(activationGradients.asOutput());
        opBuilder.addInput(learningRate.asOutput());
        opBuilder.addInput(embeddingTable.asOutput());
        opBuilder.addInput(numMinibatchesPerPhysicalSparseCore.asOutput());
        opBuilder.setAttr("table_name", tableName);
        if (options != null) {
            for (Options opts : options) {
                if (opts.clipWeightMin != null) {
                    opBuilder.setAttr("clip_weight_min", opts.clipWeightMin.floatValue());
                }
                if (opts.clipWeightMax == null) continue;
                opBuilder.setAttr("clip_weight_max", opts.clipWeightMax.floatValue());
            }
        }
        return new XlaSparseDenseMatmulGradWithSgdAndCsrInput(opBuilder.build());
    }

    public static Options clipWeightMin(Float clipWeightMin) {
        return new Options().clipWeightMin(clipWeightMin);
    }

    public static Options clipWeightMax(Float clipWeightMax) {
        return new Options().clipWeightMax(clipWeightMax);
    }

    public Output<TFloat32> updatedEmbeddingTable() {
        return this.updatedEmbeddingTable;
    }

    @Override
    public Output<TFloat32> asOutput() {
        return this.updatedEmbeddingTable;
    }

    @OpInputsMetadata(outputsClass=XlaSparseDenseMatmulGradWithSgdAndCsrInput.class)
    public static class Inputs
    extends RawOpInputs<XlaSparseDenseMatmulGradWithSgdAndCsrInput> {
        public final Operand<TInt32> rowPointers;
        public final Operand<TInt32> sortedSampleIds;
        public final Operand<TInt32> sortedTokenIds;
        public final Operand<TFloat32> sortedGains;
        public final Operand<TFloat32> activationGradients;
        public final Operand<TFloat32> learningRate;
        public final Operand<TFloat32> embeddingTable;
        public final Operand<TInt32> numMinibatchesPerPhysicalSparseCore;
        public final float clipWeightMin;
        public final float clipWeightMax;
        public final String tableName;

        public Inputs(GraphOperation op) {
            super(new XlaSparseDenseMatmulGradWithSgdAndCsrInput(op), op, Arrays.asList("clip_weight_min", "clip_weight_max", "table_name"));
            int inputIndex = 0;
            this.rowPointers = op.input(inputIndex++);
            this.sortedSampleIds = op.input(inputIndex++);
            this.sortedTokenIds = op.input(inputIndex++);
            this.sortedGains = op.input(inputIndex++);
            this.activationGradients = op.input(inputIndex++);
            this.learningRate = op.input(inputIndex++);
            this.embeddingTable = op.input(inputIndex++);
            this.numMinibatchesPerPhysicalSparseCore = op.input(inputIndex++);
            this.clipWeightMin = op.attributes().getAttrFloat("clip_weight_min");
            this.clipWeightMax = op.attributes().getAttrFloat("clip_weight_max");
            this.tableName = op.attributes().getAttrString("table_name");
        }
    }

    public static class Options {
        private Float clipWeightMin;
        private Float clipWeightMax;

        private Options() {
        }

        public Options clipWeightMin(Float clipWeightMin) {
            this.clipWeightMin = clipWeightMin;
            return this;
        }

        public Options clipWeightMax(Float clipWeightMax) {
            this.clipWeightMax = clipWeightMax;
            return this;
        }
    }
}

