/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.sparse;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TInt64;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="DenseCountSparseOutput", inputsClass=Inputs.class)
public final class DenseCountSparseOutput<U extends TNumber>
extends RawOp {
    public static final String OP_NAME = "DenseCountSparseOutput";
    private Output<TInt64> outputIndices;
    private Output<U> outputValues;
    private Output<TInt64> outputDenseShape;

    public DenseCountSparseOutput(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.outputIndices = operation.output(outputIdx++);
        this.outputValues = operation.output(outputIdx++);
        this.outputDenseShape = operation.output(outputIdx++);
    }

    public static <U extends TNumber> DenseCountSparseOutput<U> create(Scope scope, Operand<? extends TNumber> values, Operand<U> weights, Boolean binaryOutput, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(values.asOutput());
        opBuilder.addInput(weights.asOutput());
        opBuilder.setAttr("binary_output", binaryOutput);
        if (options != null) {
            for (Options opts : options) {
                if (opts.minlength != null) {
                    opBuilder.setAttr("minlength", opts.minlength);
                }
                if (opts.maxlength == null) continue;
                opBuilder.setAttr("maxlength", opts.maxlength);
            }
        }
        return new DenseCountSparseOutput<U>(opBuilder.build());
    }

    public static Options minlength(Long minlength) {
        return new Options().minlength(minlength);
    }

    public static Options maxlength(Long maxlength) {
        return new Options().maxlength(maxlength);
    }

    public Output<TInt64> outputIndices() {
        return this.outputIndices;
    }

    public Output<U> outputValues() {
        return this.outputValues;
    }

    public Output<TInt64> outputDenseShape() {
        return this.outputDenseShape;
    }

    @OpInputsMetadata(outputsClass=DenseCountSparseOutput.class)
    public static class Inputs<U extends TNumber>
    extends RawOpInputs<DenseCountSparseOutput<U>> {
        public final Operand<? extends TNumber> values;
        public final Operand<U> weights;
        public final DataType T;
        public final long minlength;
        public final long maxlength;
        public final boolean binaryOutput;
        public final DataType outputType;

        public Inputs(GraphOperation op) {
            super(new DenseCountSparseOutput(op), op, Arrays.asList("T", "minlength", "maxlength", "binary_output", "output_type"));
            int inputIndex = 0;
            this.values = op.input(inputIndex++);
            this.weights = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.minlength = op.attributes().getAttrInt("minlength");
            this.maxlength = op.attributes().getAttrInt("maxlength");
            this.binaryOutput = op.attributes().getAttrBool("binary_output");
            this.outputType = op.attributes().getAttrType("output_type");
        }
    }

    public static class Options {
        private Long minlength;
        private Long maxlength;

        private Options() {
        }

        public Options minlength(Long minlength) {
            this.minlength = minlength;
            return this;
        }

        public Options maxlength(Long maxlength) {
            this.maxlength = maxlength;
            return this;
        }
    }
}

