/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.quantization;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.TFloat32;
import org.tensorflow.types.family.TNumber;

@OpMetadata(opType="Dequantize", inputsClass=Inputs.class)
public final class Dequantize<U extends TNumber>
extends RawOp
implements Operand<U> {
    public static final String OP_NAME = "Dequantize";
    private Output<U> output;

    public Dequantize(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <U extends TNumber> Dequantize<U> create(Scope scope, Operand<? extends TNumber> input, Operand<TFloat32> minRange, Operand<TFloat32> maxRange, Class<U> dtype, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(minRange.asOutput());
        opBuilder.addInput(maxRange.asOutput());
        opBuilder.setAttr("dtype", Operands.toDataType(dtype));
        if (options != null) {
            for (Options opts : options) {
                if (opts.mode != null) {
                    opBuilder.setAttr("mode", opts.mode);
                }
                if (opts.narrowRange != null) {
                    opBuilder.setAttr("narrow_range", opts.narrowRange);
                }
                if (opts.axis == null) continue;
                opBuilder.setAttr("axis", opts.axis);
            }
        }
        return new Dequantize<U>(opBuilder.build());
    }

    public static Dequantize<TFloat32> create(Scope scope, Operand<? extends TNumber> input, Operand<TFloat32> minRange, Operand<TFloat32> maxRange, Options[] options) {
        return Dequantize.create(scope, input, minRange, maxRange, TFloat32.class, options);
    }

    public static Options mode(String mode) {
        return new Options().mode(mode);
    }

    public static Options narrowRange(Boolean narrowRange) {
        return new Options().narrowRange(narrowRange);
    }

    public static Options axis(Long axis) {
        return new Options().axis(axis);
    }

    public Output<U> output() {
        return this.output;
    }

    @Override
    public Output<U> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=Dequantize.class)
    public static class Inputs
    extends RawOpInputs<Dequantize<?>> {
        public final Operand<? extends TNumber> input;
        public final Operand<TFloat32> minRange;
        public final Operand<TFloat32> maxRange;
        public final DataType T;
        public final String mode;
        public final boolean narrowRange;
        public final long axis;
        public final DataType dtype;

        public Inputs(GraphOperation op) {
            super(new Dequantize(op), op, Arrays.asList("T", "mode", "narrow_range", "axis", "dtype"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.minRange = op.input(inputIndex++);
            this.maxRange = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.mode = op.attributes().getAttrString("mode");
            this.narrowRange = op.attributes().getAttrBool("narrow_range");
            this.axis = op.attributes().getAttrInt("axis");
            this.dtype = op.attributes().getAttrType("dtype");
        }
    }

    public static class Options {
        private String mode;
        private Boolean narrowRange;
        private Long axis;

        private Options() {
        }

        public Options mode(String mode) {
            this.mode = mode;
            return this;
        }

        public Options narrowRange(Boolean narrowRange) {
            this.narrowRange = narrowRange;
            return this;
        }

        public Options axis(Long axis) {
            this.axis = axis;
            return this;
        }
    }
}

